﻿using System;
using System.Runtime.Serialization;

namespace Btsss.Plugins.VIMT.Appointments.Messages
{
    [DataContract]
    public class LoadVISTAAppointmentsDateRangeResponse
    {
        [DataMember]
        public string DateRangeSearch { get; set; }

        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }
        [DataMember]
        public VeteranAppointment[] Appointments { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }
    }

    [DataContract]
    public class LoadVISTAAppointmentDetailResponse
    {
        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public string OriginatingSystemIdentifier { get; set; }

        [DataMember]
        public string AppointmentIdentifier { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public DateTime AppointmentDate { get; set; }

        [DataMember]
        public string AppointmentStatus { get; set; }

        [DataMember]
        public string SOPCode { get; set; }

        [DataMember]
        public Boolean IsInNetwork { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }
    }


    [DataContract]
    public class VeteranAppointment
    {
        [DataMember]
        public string OriginatingSystemIdentifier { get; set; }

        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public DateTime AppointmentDate { get; set; }

        [DataMember]
        public string AppointmentStatus { get; set; }

        [DataMember]
        public string SOPCode { get; set; }

        [DataMember]
        public string AppointmentIdentifier { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }
    }

}
