﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Configuration;
using Microsoft.Xrm.Sdk.Client;
using System.Security;
using System.ServiceModel.Description;
using Microsoft.Xrm.Sdk.Messages;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk;
using System.Collections.Generic;

namespace Btsss.Plugins.ContactProfile.UnitTests
{
    [TestClass]
    public class PluginRetrieveMultiple
    {
        private Uri DiscoveryServiceUri
        {
            get
            {
                return new Uri("http://base2012/XRMServices/2011/Discovery.svc");
            }
        }
        private Uri OrganizationServiceUri
        {
            get
            {
                return new Uri("http://base2012/BTSSS/XRMServices/2011/Organization.svc");
            }
        }

        private OrganizationServiceProxy _serviceProxy;
        private Btsss.Plugins.Helpers.ServerConnection.Configuration serverConfig { get; set; }

        [TestMethod]
        public void CallRetrieveMultiple()
        {
            serverConfig = new Helpers.ServerConnection.Configuration();
            //creds.Windows.ClientCredential.Domain = "libertyitsazure";
            //creds.Windows.ClientCredential.UserName = "abarge";
            serverConfig.Credentials = new ClientCredentials();

            serverConfig.Credentials.Windows.ClientCredential.Domain = "vmservers.local";
            serverConfig.Credentials.Windows.ClientCredential.UserName = "administrator";
            serverConfig.Credentials.Windows.ClientCredential.Password = "pass@word1@";

            serverConfig.OrganizationUri = new Uri(OrganizationServiceUri.ToString());

            serverConfig.DeviceCredentials = Btsss.Plugins.Helpers.DeviceIdManager.LoadDeviceCredentials();
            serverConfig.HomeRealmUri = null;

            // Connect to CRM and make a call to invoke a RetrieveMultiple so that our plugin picks it up.
            using (_serviceProxy = new OrganizationServiceProxy(serverConfig.OrganizationUri, serverConfig.HomeRealmUri, serverConfig.Credentials, serverConfig.DeviceCredentials))
            {
                List<Entity> contactRecords = new List<Entity>();

                // Create an Expression to execute
                QueryExpression qe = new QueryExpression("contact");
                qe.ColumnSet = new ColumnSet( true );

                // return all contacts
                var request = _serviceProxy.RetrieveMultiple(qe);

                if(request != null && request.TotalRecordCount < 1)
                {
                    Assert.Fail("null contact return object, or zero return contact records");
                }
                else
                {
                    foreach(var ent in request.Entities)
                    {
                        // do a retrieve so that the retrieve code is tested too.
                        var record = _serviceProxy.Retrieve("contact", ent.Id, new ColumnSet(true));

                        // Get any VIMT record so that it can be reviews either in Debug or in exressions as part of this UT.
                        if(ent.Attributes.Contains("btsss_icn") && ent.Attributes.Contains("btsss_facilityidentifier"))
                        {
                            contactRecords.Add(record);
                        }
                    }
                }

                // Evaluate the return collection
                Assert.IsTrue(contactRecords.Count > 0);
            }
        }
    }
}
