using System;
using System.ServiceModel;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Messages;
using Microsoft.Xrm.Sdk.Query;
using System.Net;
using System.Text;
using System.IO;
using System.Runtime.Serialization.Json;
using System.Xml;

namespace BTSSS.ID.ME
{

    /// <summary>
    /// PluginEntryPoint plug-in.
    /// This is a generic entry point for a plug-in class. Use the Plug-in Registration tool found in the CRM SDK to register this class, import the assembly into CRM, and then create step associations.
    /// A given plug-in can have any number of steps associated with it. 
    /// </summary>    
    public class PluginEntryPoint : PluginBase
    {
        string SecureConfiguration = "";
        public string Contact_OData_URL { get; set; }

        void ParseConfigurationData()
        {
            XmlDocument xml = new XmlDocument();
            xml.LoadXml(SecureConfiguration);

            XmlNodeList xnList = xml.SelectNodes("/Configuration/OData_URL");
            foreach (XmlNode xn in xnList)
            {
                Contact_OData_URL = xn["Contact"].InnerText;
            }
        }

        private bool ContactExists(LocalPluginContext localContext, string email)
        {
            bool result = false;

            try
            {
                using (WebClient client = new WebClient())
                {
                    byte[] responseBytes = client.DownloadData(Contact_OData_URL);
                    string response = Encoding.UTF8.GetString(responseBytes);

                    //localContext.Trace("Contact OData: " + response);

                    ContactDataParser cdp = new ContactDataParser();
                    cdp.ParseData(response);
                    localContext.Trace("Contacts in ODatafeed: " + cdp.Contacts.Count);

                    localContext.Trace("Checking BTSSS contacts data for the email of: " + email);
                    result = cdp.ContactExistsByEmail(email);

                    localContext.Trace("result: " + result);
                }
            }

            catch (WebException exception)
            {
                localContext.Trace("Exception: {0}" + exception.ToString());
                throw;
            }

            return result;
        }
        /// <summary>
        /// Initializes a new instance of the <see cref="PluginEntryPoint"/> class.
        /// </summary>
        /// <param name="unsecure">Contains public (unsecured) configuration information.</param>
        /// <param name="secure">Contains non-public (secured) configuration information. 
        /// When using Microsoft Dynamics CRM for Outlook with Offline Access, 
        /// the secure string is not passed to a plug-in that executes while the client is offline.</param>
        public PluginEntryPoint(string unsecure, string secure)
            : base(typeof(PluginEntryPoint))
        {

            // TODO: Implement your custom configuration handling.
            SecureConfiguration = secure;
        }

        public string PayLoad { get; private set; }


        /// <summary>
        /// Main entry point for he business logic that the plug-in is to execute.
        /// </summary>
        /// <param name="localContext">The <see cref="LocalPluginContext"/> which contains the
        /// <see cref="IPluginExecutionContext"/>,
        /// <see cref="IOrganizationService"/>
        /// and <see cref="ITracingService"/>
        /// </param>
        /// <remarks>
        /// For improved performance, Microsoft Dynamics CRM caches plug-in instances.
        /// The plug-in's Execute method should be written to be stateless as the constructor
        /// is not called for every invocation of the plug-in. Also, multiple system threads
        /// could execute the plug-in at the same time. All per invocation state information
        /// is stored in the context. This means that you should not use global variables in plug-ins.
        /// </remarks>
        protected override void ExecuteCrmPlugin(LocalPluginContext localContext)
        {
            if (localContext == null)
            {
                throw new ArgumentNullException("localContext");
            }

            // TODO: Implement your custom plug-in business logic.
            localContext.Trace("Started ExecuteCrmPlugin");
            localContext.Trace("Secure Configuration String: " + SecureConfiguration);

            Entity entity;

            ParseConfigurationData();
            localContext.Trace("Contact OData URL: " + Contact_OData_URL);

            if (localContext.PluginExecutionContext.InputParameters.Contains("Target") &&
                localContext.PluginExecutionContext.InputParameters["Target"] is Entity &&
                localContext.PluginExecutionContext.Stage.Equals(20))
            {
                localContext.Trace("inside exec block - stage 20 - pre operation");
                entity = (Entity)localContext.PluginExecutionContext.InputParameters["Target"];
                localContext.Trace("read entity: " + entity.LogicalName);

                localContext.Trace("access_token: " + entity["btsss_access_token"].ToString());
                entity["btsss_payload"] = "PayLoad";
                localContext.Trace("assigned temp payload");

                if (entity.LogicalName == "btsss_idme")
                {
                    localContext.Trace("in the zone");

                    if (entity.Attributes.Contains("btsss_access_token") == true)
                    {
                        GetIDMEPayLoad(localContext, entity);

                        IDMEPayLoad ParsedPayLoad = IDMEJsonToObject(localContext);
                        localContext.Trace("Email: " + ParsedPayLoad.email);
                        localContext.Trace("UUID: " + ParsedPayLoad.uuid);

                        SetBTSSSDataFromIDMEPayload(localContext, entity, ParsedPayLoad);
                    }
                }
            }

            localContext.Trace("DONE");

            localContext.Trace("Completed ExecuteCrmPlugin");
        }

        private void SetBTSSSDataFromIDMEPayload(LocalPluginContext localContext, Entity entity, IDMEPayLoad ParsedPayLoad)
        {
            bool bContactExists = ContactExists(localContext, ParsedPayLoad.email);

            entity["btsss_id"] = ParsedPayLoad.id;
            entity["btsss_verified"] = ParsedPayLoad.verified;
            entity["btsss_affiliation"] = ParsedPayLoad.affiliation;
            entity["btsss_fname"] = ParsedPayLoad.fname;
            entity["btsss_lname"] = ParsedPayLoad.lname;
            entity["btsss_email"] = ParsedPayLoad.email;
            entity["btsss_uuid"] = ParsedPayLoad.uuid;
            entity["btsss_contact_in_btsss"] = bContactExists;

            entity["btsss_payload"] = PayLoad;
        }

        private void GetIDMEPayLoad(LocalPluginContext localContext, Entity entity)
        {
            localContext.Trace("grabbing access_token");
            string access_token = entity["btsss_access_token"].ToString();

            string page = "https://api.idmelabs.com/api/public/v2/attributes.json ?access_token=" + access_token;
            localContext.Trace("web address: " + page);

            localContext.Trace("connecting and retrieving payload");
            try
            {
                localContext.Trace("Downloading the target URI: " + page);

                try
                {
                    using (WebClient client = new WebClient())
                    {
                        byte[] responseBytes = client.DownloadData(page);
                        string response = Encoding.UTF8.GetString(responseBytes);

                        localContext.Trace("response: " + response);
                        PayLoad = response;
                    }
                }

                catch (WebException exception)
                {
                    localContext.Trace("Exception: {0}" + exception.ToString());
                    throw;
                }
            }
            catch (Exception e)
            {
                localContext.Trace("Exception: {0}" + e.ToString());
                throw;
            }

            entity["btsss_payload"] = PayLoad;
            localContext.Trace("stored IDME payload");
        }

        private IDMEPayLoad IDMEJsonToObject(LocalPluginContext localContext)
        {
            IDMEPayLoad SerializedObject = null;

            localContext.Trace("Starting to parse...");

            using (MemoryStream DeSerializememoryStream = new MemoryStream())
            {
                //initialize DataContractJsonSerializer object and pass Student class type to it
                DataContractJsonSerializer serializer = new DataContractJsonSerializer(typeof(IDMEPayLoad));
                localContext.Trace("got serializer");

                //user stream writer to write JSON string data to memory stream
                StreamWriter writer = new StreamWriter(DeSerializememoryStream);
                localContext.Trace("Payload is " + PayLoad);
                writer.Write(PayLoad);
                writer.Flush();

                DeSerializememoryStream.Position = 0;
                SerializedObject = (IDMEPayLoad)serializer.ReadObject(DeSerializememoryStream);
            }

            localContext.Trace("serialized object id: " + SerializedObject.id);
            return SerializedObject;
        }

    }
}
