﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace BTSSS.ID.ME
{
    public class Contact
    {
        public string contactid { get; set; }
        public string fullname { get; set; }
        public string emailaddress1 { get; set; }
        public string firstname { get; set; }
        public string lastname { get; set; }
        public string adx_identity_username { get; set; }
        public string adx_username { get; set; }
    }


    class ContactDataParser
    {
        public List<Contact> Contacts = new List<Contact>();


        private void SetObjectProperty(string propertyName, string value, object obj)
        {
            PropertyInfo propertyInfo = obj.GetType().GetProperty(propertyName);
            // make sure object has the property we are after
            if (propertyInfo != null)
            {
                propertyInfo.SetValue(obj, value, null);
            }
        }

        public void ParseData(string data)
        {

            string[] records = data.Split(new char[] { '[' })[1].Split(new char[] { ']' })[0].Split(new string[] { "},{" }, StringSplitOptions.None);


            foreach (var item in records)
            {
                Contact cntct = new Contact();

                string[] Field_Value_Pairs = item.Split(new string[] { "," }, StringSplitOptions.None);
                foreach (var fv in Field_Value_Pairs)
                {
                    string field_name = fv.Split(new string[] { ":" }, StringSplitOptions.None)[0];
                    string value = fv.Split(new string[] { ":" }, StringSplitOptions.None)[1];

                    field_name = field_name.Replace("{", "").Trim();
                    field_name = field_name.Replace("}", "").Trim();
                    field_name = field_name.Replace("\"", "").Trim();

                    value = value.Replace("{", "").Trim();
                    value = value.Replace("}", "").Trim();
                    value = value.Replace("\"", "").Trim();

                    SetObjectProperty(field_name, value, cntct);
                }

                Contacts.Add(cntct);
            }
        }

        public bool ContactExistsByEmail(string email)
        {
            bool result = false;
            result =  Contacts.Exists((c => string.Compare(c.emailaddress1, email).Equals(0)));
            return result;
        }
    }
}
