﻿#region Directives

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

#endregion Directives

namespace MCS_AutoNumber.Common
{
	public static class ExceptionExtensions
	{
        #region Public Static Methods
        
        public static String GetDetailedOutput(this Exception ex)
        {
            return ex.GetDetailedOutput(null);
        }

        public static String GetDetailedOutput(this Exception ex, String labelFormat, params object[] args)
        {
            return GetDetailedOutput(ex, String.Format(System.Globalization.CultureInfo.CurrentCulture, labelFormat, args));
        }

        public static String GetDetailedOutput(this Exception ex, String label)
        {
            List<String> detailedOutput = new List<String>();
            if (!String.IsNullOrEmpty(label))
            {
                detailedOutput.Add(label);
            }

            detailedOutput.AddRange(new String[] {
                "Message: ", ex.Message,
                "Stack trace: ", ex.StackTrace
            });

            if (ex.InnerException != null)
            {
                detailedOutput.Add(ex.InnerException.GetDetailedOutput("Inner exception: "));
            }
            return String.Join(Environment.NewLine, detailedOutput.ToArray());
        }
        
        #endregion Public Static Methods
    }
}
