﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIMT.Integrations.eBenefits.Messages;
using VIMT.Integrations.eBenefits.WebService.Processors;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.eBenefits.WebService.Handlers
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VIMTLOADeBenefitsREQUEST)]
    public class eBenefitsHandler : RequestResponseHandler
    {
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                var eBenefitsMessage = message as LoadeBenefitsRequest;
                if (eBenefitsMessage != null)
                {
                    LogMessageReceipt(eBenefitsMessage);
                    return new eBenefitsProcessor().Execute(eBenefitsMessage);
                }
                return null;
            }
            catch (Exception ex)
            {
                //Log exception and rethrow
                Logger.Instance.Error("Exception from eBenefitsHandler", ex);
                throw;
            }
        }
    }
}
