﻿using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIMT.Integrations.eBenefits.Service.Configuration;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.eBenefits.Service.Wcf
{
    public class ServiceFactory
    {
        // Uses Generic Endopint to point to the service this example does not use a header
        public static UserProfileClient GetAppealServiceReference(IOrganizationService organizationService, Guid userId)
        {
            var channel = new ServiceCustomClientChannel<UserProfileClient>("UserProfile", ConfigurationLocation.GetConfigFilePath("EC"));

            channel.Endpoint.AddSecurityHeader(organizationService, userId);

            SoapLog.Current.Active = eBenefitsConfiguration.Current.EnableLogging;

            return channel.CreateChannel();
        }

        // Uses Generic Endopint to point to the service this example does not use a header
        public static UserProfileClient GetAppealServiceReference(HeaderInfo headerInfo)
        {
            var channel = new ServiceCustomClientChannel<UserProfileClient>("UserProfile", ConfigurationLocation.GetConfigFilePath("EC"));

            channel.Endpoint.AddSecurityHeader(headerInfo);

            SoapLog.Current.Active = eBenefitsConfiguration.Current.EnableLogging;

            return channel.CreateChannel();
        }

        // Uses Generic Endopint to point to the service this example does not use a header
        public static UserProfileClient GetAppealServiceReference()
        {
            var channel = new ServiceCustomClientChannel<UserProfileClient>("UserProfile", ConfigurationLocation.GetConfigFilePath("EC"));

            return channel.CreateChannel();
        }
    }
}
