﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VIMT.Integrations.VeteranProfile.Messages;

namespace VIMT.Integrations.VeteranProfile.UnitTest
{
    [TestClass]
    public partial class VIMTStubbedDataTests
    {
#if DEBUG
        public Uri endPoint = new Uri("http://localhost:8085/ServiceBus");
#else
        public Uri endPoint = new Uri("http://crm.libertybtdev.com:8085/ServiceBus");
#endif

        [TestMethod]
        public void Test_VIMT_VeteranProfile()
        {
            Boolean ResponseTest = true;
            LoadVeteranProfileRequest req = new LoadVeteranProfileRequest();
            req.OrganizationName = "BTSSS";
            req.UserId = new Guid("4EAE06DB-70DD-E411-8437-00155D5575E0");
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.VeteranIdentifier = "1234567890";
            req.VeteranIdentifierType = "EmployeeIdentifier";
            var response = VRMRest.Utility.SendReceive<LoadVeteranProfileResponse>(endPoint, MessageRegistry.LoadVeteranProfileRequest, req, new VRMRest.LogSettings());


            if (!response.FirstName.Equals("Frank"))
                ResponseTest = false;
            if (!response.LastName.Equals("Donaldson"))
                ResponseTest = false;
            if (!response.MaskedSocial.Equals("222-00-9999"))
                ResponseTest = false;
            if (!response.DateOfBirth.Equals(new DateTime(2017, 12, 14)))
                ResponseTest = false;

            if (ResponseTest)
            {
                Assert.IsTrue(true);
            }
            else
            {
                Assert.IsTrue(false);
            }
        }
    }
}
