﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VIMT.Integrations.NetIncome.Messages;

namespace VIMT.Integrations.NetIncome.UnitTest
{
    [TestClass]
    public class VIMTStubbedDataTests
    {
#if DEBUG
        public Uri endPoint = new Uri("http://localhost:8085/ServiceBus");
#else
        public Uri endPoint = new Uri("http://crm.libertybtdev.com:8085/ServiceBus");
#endif

        [TestMethod]
        public void TEST_VIMT_Initial_NetIncome_Message()
        {
            LoadNetIncomeRequest req = new LoadNetIncomeRequest();
            req.EdiPi = "1234567890";
            req.PatientIdentifier = "1234567890";
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();
            var response = VRMRest.Utility.SendReceive<LoadNetIncomeResponse>(endPoint, MessageRegistry.LoadNetIncomeRequest, req, null);

            Assert.IsTrue(true);
        }
    }
}
