﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VIMT.Integrations.MVI.Messages;

namespace VIMT.Integrations.MVI.UnitTest
{
    [TestClass]
    public class VIMTServiceDataTests
    {
#if Release
        public Uri endPoint = new Uri("http://crm.libertybtdev.com:8085/ServiceBus");
#else
        public Uri endPoint = new Uri("http://localhost:8085/ServiceBus");
#endif
        [TestMethod]
        public void TEST_VIMT_MVI_Message()
        {
            RetrieveWithOrchestrationRequest req = new RetrieveWithOrchestrationRequest();
            req.PatientIdentifier = "1234567890";
            req.AssigningAuthority = "DOD";
            req.AssigningFacility = "317";
            req.FetchMessageProcessType = VRM.Integration.Servicebus.Core.MessageProcessType.Remote;
            req.IdentifierType = "EmployeeIdentifier";
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = new System.Guid();

            var response = VRMRest.Utility.SendReceive<RetrieveOrSearchPersonResponse>(endPoint, MessageRegistry.RetrieveWithOrchestrationRequest, req, null);

            Assert.AreEqual(response.Person[0].ParticipantId, "1234567890");
        }
    }
}
