﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using VIMT.Integrations.MVI.UnitTest.DataStubServiceReference;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.MVI.UnitTest
{
    [TestClass]
    public class IMSStubbedDataTests
    {
        [TestMethod]
        public void TEST_IMS_Direct_MVI()
        {
            DataStubServiceClient proxy = new DataStubServiceClient();

            RetrieveWithOrchestrationRequest req = new RetrieveWithOrchestrationRequest();
            req.PatientIdentifier = "1234567890";
            req.AssigningAuthority = "DOD";
            req.AssigningFacility = "317";
            req.FetchMessageProcessType = MessageProcessType.Remote;
            req.IdentifierType = "EmployeeIdentifier";
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = new System.Guid();

            RetrieveOrSearchPersonResponse response = proxy.getRetrieveOrSearchPersonResponseStubData(req);

            Assert.AreEqual(response.Person[0].ParticipantId.ToString(), "1234567890");
        }
    }
}
