﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VIMT.Integrations.FMS.Messages;

namespace FMS.BankInfo.UnitTest
{
    [TestClass]
    public class VIMTStubbedDataTests
    {
#if DEBUG
        public Uri endPoint = new Uri("http://localhost:8085/ServiceBus");
#else
        public Uri endPoint = new Uri("http://crm.libertybtdev.com:8085/ServiceBus");
#endif

        [TestMethod]
        public void TEST_VIMT_Initial_BankInformation_Message()
        {
            LoadBankInformationRequest req = new LoadBankInformationRequest();
            req.EdiPi = "1234567890";
            req.PatientIdentifier = "1234567890";
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserId = Guid.NewGuid();
            req.UserLastName = "Barge";

            var response = VRMRest.Utility.SendReceive<LoadBankInformationResponse>(endPoint, MessageRegistry.LoadBankInformationRequest, req, null);

            Assert.IsTrue(true);
        }
    }
}
