﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VIMT.Integrations.FMS.Messages;

namespace VIMT.Integrations.NetIncome.UnitTest
{
    [TestClass]
    public class VIMTServiceDataTests
    {
#if Release
        public Uri endPoint = new Uri("http://crm.libertybtdev.com:8085/ServiceBus");
#else
        public Uri endPoint = new Uri("http://localhost:8085/ServiceBus");
#endif
        [TestMethod]
        public void TEST_VIMT_BankInformation_Message()
        {
            LoadBankInformationRequest req = new LoadBankInformationRequest();
            req.EdiPi = "1234567890";
            req.OrganizationName = "BTSSS";
            req.PatientIdentifier = "1234567890";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            var response = VRMRest.Utility.SendReceive<LoadBankInformationResponse>(endPoint, MessageRegistry.LoadBankInformationRequest, req, null);

            Assert.AreEqual(response.BankAccountNumber, "123456789");
        }
    }
}
