﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VIMT.Integrations.Appointments.Messages;

namespace VIMT.Integrations.Appointments.UnitTest
{
    [TestClass]
    public class VIMTServiceDataTests
    {
        private Uri VIMTEndpoint = new Uri("http://localhost:8085/ServiceBus");
        //        private Uri VIMTEndpoint = new Uri("http://vaazlintbts1.libertyitsazure.com:8085/Servicebus");
        //        private Uri VIMTEndpoint = new Uri("http://vaazlintbts2.libertyitsazure.com:8085/Servicebus");

        [TestMethod]
        public void TEST_VIMT_Valid_Appointment_Range()
        {

            LoadVISTAAppointmentsDateRangeRequest req = new LoadVISTAAppointmentsDateRangeRequest();
            req.AppointmentStartDate = new DateTime(2016, 12, 1).ToString();
            req.AppointmentEndDate = new DateTime(2017, 6, 1).ToString();
            req.FacilityIdentifier = string.Empty;
            req.PatientIdentifier = string.Empty;
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            var response = VRMRest.Utility.SendReceive<LoadVISTAAppointmentsDateRangeResponse>(VIMTEndpoint, MessageRegistry.LoadVISTAAppointmentsDateRangeRequest, req, null);

            Assert.AreEqual("StartRange: 12/1/2016 | EndRange: 6/1/2017", response.DateRangeSearch.ToString());
        }

        [TestMethod]
        public void TEST_VIMT_StartDateMissing_AppointmentRange()
        {
            LoadVISTAAppointmentsDateRangeRequest req = new LoadVISTAAppointmentsDateRangeRequest();
            req.AppointmentEndDate = new DateTime(2017, 6, 1).ToString();
            req.FacilityIdentifier = string.Empty;
            req.PatientIdentifier = string.Empty;
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            var response = VRMRest.Utility.SendReceive<LoadVISTAAppointmentsDateRangeResponse>(VIMTEndpoint, MessageRegistry.LoadVISTAAppointmentsDateRangeRequest, req, null);

            Assert.AreEqual("EndRange: 6/1/2017", response.DateRangeSearch.ToString());
        }

        [TestMethod]
        public void TEST_VIMT_EndDateMissing_AppointmentRange()
        {
            LoadVISTAAppointmentsDateRangeRequest req = new LoadVISTAAppointmentsDateRangeRequest();

            req.AppointmentStartDate = new DateTime(2016, 12, 1).ToString();
            req.FacilityIdentifier = string.Empty;
            req.PatientIdentifier = string.Empty;
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            var response = VRMRest.Utility.SendReceive<LoadVISTAAppointmentsDateRangeResponse>(VIMTEndpoint, MessageRegistry.LoadVISTAAppointmentsDateRangeRequest, req, null);

            Assert.AreEqual("StartRange: 12/1/2016", response.DateRangeSearch.ToString());
        }

        [TestMethod]
        public void TEST_VIMT_InvalidRange_AppointmentRange()
        {
            LoadVISTAAppointmentsDateRangeRequest req = new LoadVISTAAppointmentsDateRangeRequest();

            req.AppointmentStartDate = new DateTime(2017, 6, 1).ToString();
            req.AppointmentEndDate = new DateTime(2016, 12, 1).ToString();
            req.FacilityIdentifier = string.Empty;
            req.PatientIdentifier = string.Empty;
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            var response = VRMRest.Utility.SendReceive<LoadVISTAAppointmentsDateRangeResponse>(VIMTEndpoint, MessageRegistry.LoadVISTAAppointmentsDateRangeRequest, req, null);

            Assert.AreEqual("Invalid Date Range requested. StartDate was greater than EndDate. Unable to process Request.", response.Message.ToString());
        }

        [TestMethod]
        public void TEST_VIMT_Appointments_NoParameters()
        {
            LoadVISTAAppointmentsDateRangeRequest req = new LoadVISTAAppointmentsDateRangeRequest();

            req.OrganizationName = "BTSSS";
            req.PatientIdentifier = "1234567890";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();
            var response = VRMRest.Utility.SendReceive<LoadVISTAAppointmentsDateRangeResponse>(VIMTEndpoint, MessageRegistry.LoadVISTAAppointmentsDateRangeRequest, req, null);

            Assert.IsTrue(response.Appointments.Length == 3);
        }

        [TestMethod]
        public void TEST_VIMT_Appointment_With_OneParameter()
        {
            LoadVISTAAppointmentDetailRequest req = new LoadVISTAAppointmentDetailRequest();

            req.AppointmentIdentifier = "000000000000005";
            req.FacilityIdentifier = string.Empty;
            req.PatientIdentifier = string.Empty;
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            var response = VRMRest.Utility.SendReceive<LoadVISTAAppointmentDetailResponse>(VIMTEndpoint, MessageRegistry.LoadVISTAAppointmentDetailRequest, req, null);

            Assert.AreEqual(response.SOPCode.ToString(), "SOP115");
        }

        [TestMethod]
        public void TEST_VIMT_Appointment_With_TwoParameters()
        {
            LoadVISTAAppointmentDetailRequest req = new LoadVISTAAppointmentDetailRequest();

            req.AppointmentIdentifier = "000000000000005";
            req.PatientIdentifier = "0987654321";
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            var response = VRMRest.Utility.SendReceive<LoadVISTAAppointmentDetailResponse>(VIMTEndpoint, MessageRegistry.LoadVISTAAppointmentDetailRequest, req, null);

            Assert.AreEqual(response.SOPCode.ToString(), "SOP115");
        }
    }
}
