﻿using System;
using VIMT.Integrations.Appointments.UnitTest.DataStubServiceReference;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace VIMT.Integrations.IMS.UnitTest
{
    [TestClass]
    public class IMSStubbedDataTests
    {
        [TestMethod]
        public void TEST_IMS_Valid_Appointment_Range()
        {
            DataStubServiceClient proxy = new DataStubServiceClient();

            VISTAVeteranAppointmentDateRangeRequest req = new VISTAVeteranAppointmentDateRangeRequest();
            req.AppointmentStartDate = new DateTime(2016, 12, 1);
            req.AppointmentEndDate = new DateTime(2017, 6, 1);
            req.FacilityIdentifier = string.Empty;
            req.PatientIdentifier = string.Empty;
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();
            req.MessageId = Guid.NewGuid();

            VISTAVeteranAppointmentDateRangeResponse response = proxy.getVISTAVeteranAppointmentsByDateRange(req);

            Assert.AreEqual("StartRange: 12/1/2016 | EndRange: 6/1/2017", response.DateRangeSearch.ToString());
        }

        [TestMethod]
        public void TEST_IMS_StartDateMissing_AppointmentRange()
        {
            DataStubServiceClient proxy = new DataStubServiceClient();

            VISTAVeteranAppointmentDateRangeRequest req = new VISTAVeteranAppointmentDateRangeRequest();
            req.AppointmentEndDate = new DateTime(2017, 6, 1);
            req.FacilityIdentifier = string.Empty;
            req.PatientIdentifier = string.Empty;
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            VISTAVeteranAppointmentDateRangeResponse response = proxy.getVISTAVeteranAppointmentsByDateRange(req);

            Assert.AreEqual("EndRange: 6/1/2017", response.DateRangeSearch.ToString());
        }

        [TestMethod]
        public void TEST_IMS_EndDateMissing_AppointmentRange()
        {
            DataStubServiceClient proxy = new DataStubServiceClient();

            VISTAVeteranAppointmentDateRangeRequest req = new VISTAVeteranAppointmentDateRangeRequest();
            req.AppointmentStartDate = new DateTime(2016, 12, 1);
            req.FacilityIdentifier = string.Empty;
            req.PatientIdentifier = string.Empty;
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            VISTAVeteranAppointmentDateRangeResponse response = proxy.getVISTAVeteranAppointmentsByDateRange(req);

            Assert.AreEqual("StartRange: 12/1/2016", response.DateRangeSearch.ToString());
        }

        [TestMethod]
        public void TEST_IMS_InvalidRange_AppointmentRange()
        {
            DataStubServiceClient proxy = new DataStubServiceClient();

            VISTAVeteranAppointmentDateRangeRequest req = new VISTAVeteranAppointmentDateRangeRequest();
            req.AppointmentStartDate = new DateTime(2017, 6, 1);
            req.AppointmentEndDate = new DateTime(2016, 12, 1);
            req.FacilityIdentifier = string.Empty;
            req.PatientIdentifier = string.Empty;
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            VISTAVeteranAppointmentDateRangeResponse response = proxy.getVISTAVeteranAppointmentsByDateRange(req);

            Assert.AreEqual("Invalide Date Range", response.DateRangeSearch.ToString());
        }

        [TestMethod]
        public void TEST_IMS_Appointment_NoRecords_For_AppointmentIdentifier()
        {
            DataStubServiceClient proxy = new DataStubServiceClient();

            VISTAVeteranAppointmentDetailRequest req = new VISTAVeteranAppointmentDetailRequest();
            req.MessageId = Guid.NewGuid();
            req.AppointmentIdentifier = "00000000000005";
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            VISTAVeteranAppointmentDetailResponse response = proxy.getVISTAVeteranAppointmentByAppointmentIdentifier(req);

            Assert.AreEqual("No Records Returned", response.Message.ToString());
        }

        [TestMethod]
        public void TEST_IMS_Appointment_OneParameter()
        {
            DataStubServiceClient proxy = new DataStubServiceClient();

            VISTAVeteranAppointmentDetailRequest req = new VISTAVeteranAppointmentDetailRequest();
            req.MessageId = Guid.NewGuid();
            req.AppointmentIdentifier = "000000000000005";
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            VISTAVeteranAppointmentDetailResponse response = proxy.getVISTAVeteranAppointmentByAppointmentIdentifier(req);

            Assert.AreEqual(response.PatientIdentifier.ToString(), "0987654321");
        }

        [TestMethod]
        public void TEST_IMS_Appointment_Two_Parameters()
        {
            DataStubServiceClient proxy = new DataStubServiceClient();

            VISTAVeteranAppointmentDetailRequest req = new VISTAVeteranAppointmentDetailRequest();
            req.MessageId = Guid.NewGuid();
            req.AppointmentIdentifier = "000000000000005";
            req.PatientIdentifier = "0987654321";
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            VISTAVeteranAppointmentDetailResponse response = proxy.getVISTAVeteranAppointmentByAppointmentIdentifier(req);

            Assert.AreEqual("SOP115", response.SOPCode.ToString());
        }

        [TestMethod]
        public void TEST_IMS_Appointment_Three_Parameters()
        {
            DataStubServiceClient proxy = new DataStubServiceClient();

            VISTAVeteranAppointmentDetailRequest req = new VISTAVeteranAppointmentDetailRequest();
            req.MessageId = Guid.NewGuid();
            req.AppointmentIdentifier = "000000000000005";
            req.PatientIdentifier = "0987654321";
            req.FacilityIdentifier = "334";
            req.OrganizationName = "BTSSS";
            req.UserFirstName = "Allen";
            req.UserLastName = "Barge";
            req.UserId = Guid.NewGuid();

            VISTAVeteranAppointmentDetailResponse response = proxy.getVISTAVeteranAppointmentByAppointmentIdentifier(req);

            Assert.AreEqual("SOP115", response.SOPCode.ToString());
        }

    }
}
