﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIMT.Integrations.NetIncome.Messages;
using VIMT.Integrations.NetIncome.Service;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;

namespace VIMT.Integrations.NetIncome.WebService.Processors
{
    public class NetIncomeProcessor
    {
        public LoadNetIncomeResponse Execute(LoadNetIncomeRequest request)
        {
            try {
                LoadNetIncomeResponse returnResponse = new LoadNetIncomeResponse();

                Service.DataStubServiceReference.VeteranNetIncomeRequest serviceRequest = new Service.DataStubServiceReference.VeteranNetIncomeRequest();
                serviceRequest.EdiPi = request.EdiPi;
                serviceRequest.PatientIdentifier = request.PatientIdentifier;
                serviceRequest.OrganizationName = request.OrganizationName;
                serviceRequest.UserFirstName = request.UserFirstName;
                serviceRequest.UserId = request.UserId;
                serviceRequest.UserLastName = request.UserLastName;

                //Service.DataStubServiceReference.IDataStubService proxy = new Service.DataStubServiceReference.DataStubServiceClient();

                //Service.DataStubServiceReference.VeteranNetIncomeResponse response = proxy.getVeteranNetIncomeInformation(serviceRequest);

                var proxy = Service.Wcf.ServiceFactory.GetAppealServiceReference(new HeaderInfo());
                var response = proxy.getVeteranNetIncomeInformation(serviceRequest);

                if (response != null)
                    returnResponse = MapNetIncomeResponse(response);


                return returnResponse;
            }
            catch (NetworkOperationCancelledException ex)
            {
                if (ex.InnerException.ToString().Contains("There was no endpoint listening"))
                {
                    throw new InvalidOperationException(ex.InnerException.ToString());
                }
                else
                {
                    throw new NetworkOperationCancelledException(ex.Message);
}
            }
            catch (Exception ex)
            {
                if (ex.InnerException != null)
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "NetIncomeProcessor, Execute", "Exception:" + ex.Message + ex.InnerException.ToString());
                }
                else
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "NetIncomeProcessor, Execute", "Exception:" + ex.Message + "No Inner Exception Text");
                }

                if (ex.Message.Contains("No Endpoint Listening"))
                {
                    throw new NetworkOperationCancelledException(ex.InnerException.ToString());
                }
                else
                {
                    throw new InvalidOperationException(ex.Message.ToString());
                }
            }
        }

        public LoadNetIncomeResponse MapNetIncomeResponse(Service.DataStubServiceReference.VeteranNetIncomeResponse response)
        {
            LoadNetIncomeResponse returnMappedResponse = new LoadNetIncomeResponse();

            returnMappedResponse.ExceptionOccured = response.ExceptionOccured;

            if (response.IncomeExpiration != null)
                returnMappedResponse.IncomeExpiration = response.IncomeExpiration;
            if (response.IncomeModifiedBy != null)
                returnMappedResponse.IncomeModifiedBy = response.IncomeModifiedBy;
            if (response.IncomeModifiedOn != null)
                returnMappedResponse.IncomeModifiedOn = response.IncomeModifiedOn;
            if (response.IncomeSource != null)
                returnMappedResponse.IncomeSource = response.IncomeSource;
            if (response.Message != null)
                returnMappedResponse.Message = response.Message;
            if (response.NetIncome != null)
                returnMappedResponse.NetIncome = response.NetIncome;
            if (response.OldNetIncome != null)
                returnMappedResponse.OldNetIncome = response.OldNetIncome;
            if (response.PatientIdentifier != null)
                returnMappedResponse.PatientIdentifier = response.PatientIdentifier;

            return returnMappedResponse;
        }
    }
}
