﻿using System;
using System.ComponentModel.Composition;
using VIMT.Integrations.NetIncome.Messages;
using VIMT.Integrations.NetIncome.WebService.Processors;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.NetIncome.WebService.Handlers
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.LoadNetIncomeRequest)]
    public class NetIncomeHandler : RequestResponseHandler
    {
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                var NetIncomeMessage = message as LoadNetIncomeRequest;
                if (NetIncomeMessage != null)
                {
                    LogMessageReceipt(NetIncomeMessage);
                    return new NetIncomeProcessor().Execute(NetIncomeMessage);
                }
                return null;
            }
            catch (Exception ex)
            {
                //Log exception and rethrow
                Logger.Instance.Error("Exception from NetIncomeHandler", ex);
                throw;
            }
        }
    }
}
