﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.NetIncome.Messages
{
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.LoadNetIncomeRequest)]
    [DataContract]
    public class LoadNetIncomeRequest : MessageBase
    {
        [DataMember]
        public string PatientIdentifier { get; set; }
        [DataMember]
        public string EdiPi { get; set; }
        [DataMember]
        public string OrganizationName { get; set; }
        [DataMember]
        public string UserFirstName { get; set; }
        [DataMember]
        public string UserLastName { get; set; }
        [DataMember]
        public Guid UserId { get; set; }
    }
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.LoadNetIncomeResponse)]
    [DataContract]
    public class LoadNetIncomeResponse : MessageBase
    {
        [DataMember]
        public string PatientIdentifier { get; set; }
        [DataMember]
        public DateTime IncomeExpiration { get; set; }
        [DataMember]
        public Guid IncomeModifiedBy { get; set; }
        [DataMember]
        public DateTime IncomeModifiedOn { get; set; }
        [DataMember]
        public string IncomeSource { get; set; }
        [DataMember]
        public string NetIncome { get; set; }
        [DataMember]
        public string OldNetIncome { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public Boolean ExceptionOccured { get; set; }
    }
}
