﻿using System;
using System.Collections.Generic;
using VIMT.Integrations.MVI.Messages;
using VIMT.Integrations.MVI.Service;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;

namespace VIMT.Integrations.MVI.WebService.Processors
{
    public class MVIProcessor
    {
        public RetrieveOrSearchPersonResponse Execute(RetrieveWithOrchestrationRequest request)
        {
            try
            {
                Service.DataStubServiceReference.RetrieveWithOrchestrationRequest mviRequest = new Service.DataStubServiceReference.RetrieveWithOrchestrationRequest();

                mviRequest.PatientIdentifier = request.PatientIdentifier;
                mviRequest.OrganizationName = request.OrganizationName;
                mviRequest.IdentifierType = request.IdentifierType;
                mviRequest.AssigningAuthority = request.AssigningAuthority;
                mviRequest.AssigningFacility = request.AssigningFacility;
                mviRequest.FetchMessageProcessType = MessageProcessType.Local;
                mviRequest.UserFirstName = request.UserFirstName;
                mviRequest.UserLastName = request.UserLastName;
                mviRequest.UserId = request.UserId;

                RetrieveOrSearchPersonResponse response = new RetrieveOrSearchPersonResponse();

                var mviException = GetMVIData(ref response, mviRequest);

                return response;
            }
            catch (NetworkOperationCancelledException ex)
            {
                if (ex.InnerException.ToString().Contains("There was no endpoint listening"))
                {
                    throw new InvalidOperationException(ex.InnerException.ToString());
                }
                else
                {
                    throw new NetworkOperationCancelledException(ex.Message);
                }
            }
            catch (Exception ex)
            {
                if (ex.InnerException != null)
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "MVIProcessor, Execute", "Exception:" + ex.Message + ex.InnerException.ToString());
                }
                else
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "MVIProcessor, Execute", "Exception:" + ex.Message + "No Inner Exception Text");
                }

                if (ex.Message.Contains("No Endpoint Listening"))
                {
                    throw new NetworkOperationCancelledException(ex.InnerException.ToString());
                }
                else
                {
                    throw new InvalidOperationException(ex.Message.ToString());
                }
            }
        }

        #region MVI Integration Region
        // MVI will need to be different in that we do not have the source code to the message processor and therefore cant switch between IMS or 
        // Some other data source either stubbed or real.
        private Boolean GetMVIData(ref RetrieveOrSearchPersonResponse response, Service.DataStubServiceReference.RetrieveWithOrchestrationRequest mviRequest)
        {
            var proxy = Service.Wcf.ServiceFactory.GetAppealServiceReference(new HeaderInfo());
            var mviResponse = proxy.getRetrieveOrSearchPersonResponseStubData(mviRequest);

            if (mviResponse != null)
            {
                mviMapResponse(ref response, mviResponse);
            }

            if (response.ExceptionOccured == true)
            {
                return false;
            }
            else
            {
                return true;
            }

        }

        private void mviMapResponse(ref RetrieveOrSearchPersonResponse response, Service.DataStubServiceReference.RetrieveOrSearchPersonResponse mviResponse)
        {
            response.ExceptionOccured = mviResponse.ExceptionOccured;
            response.Message = mviResponse.Message;

            if (mviResponse.Message != null)
                response.Message = mviResponse.Message;
            if (mviResponse.Person != null)

                mviMapPatient(ref response, mviResponse.Person);
        }
        private void mviMapPatient(ref RetrieveOrSearchPersonResponse response, Service.DataStubServiceReference.PatientPerson[] mviPerson)
        {
            #region PatientPerson General Fields

            // TODO: Until we have a directive on what information we need from MVI specifically we will have to make assumptions and hard code them
            // For now the Patient person record will have to be assumed to be the first one
            // TODO: Need to remove the hard coded value for Patient person record and allow that to be driven by values passed in or return them all
            // For now the Address to use will be the one listed as the HOME address if there is one
            // TODO: Need to remove the hard coded value for the Address information and allow that to be driven by values passed in.
            // For now the Name to use will be the Legal Name
            // TODO: Need to remove the hard coded value for the Name information and allow that to be driven by values passed in.

            // Set the top level single items first
            if (mviPerson != null)
            {
                //for (int i = 0; i < mviPerson.Length; i++)  // Deprecated until the real payload can be determined
                if (mviPerson.Length > 0 && mviPerson[0] != null)
                {
                    int i = 0;
                    response.Person = new PatientPerson[1];
                    response.Person[0] = new PatientPerson();

                    if (mviPerson[i].ParticipantId != null)
                        response.Person[i].ParticipantId = mviPerson[i].ParticipantId;
                    if (mviPerson[i].EdiPi != null)
                        response.Person[i].EdiPi = mviPerson[i].EdiPi;
                    if (mviPerson[i].Identifier != null)
                        response.Person[i].Identifier = mviPerson[i].Identifier;
                    if (mviPerson[i].IdentifierType != null)
                        response.Person[i].IdentifierType = mviPerson[i].IdentifierType;
                    if (mviPerson[i].BirthDate != null)
                        response.Person[i].BirthDate = DateTime.Parse(mviPerson[i].BirthDate).ToString();
                    if (mviPerson[i].DeceasedDate != null)
                        response.Person[i].DeceasedDate = DateTime.Parse(mviPerson[i].DeceasedDate).ToString();
                    if (mviPerson[i].GenderCode != null)
                        response.Person[i].GenderCode = mviPerson[i].GenderCode;
                    if (mviPerson[i].PhoneNumber != null)
                        response.Person[i].PhoneNumber = mviPerson[i].PhoneNumber;
                    if (mviPerson[i].RecordSource != null)
                        response.Person[i].RecordSource = mviPerson[i].RecordSource;
                    if (mviPerson[i].SocialSecurityNumber != null)
                        response.Person[i].SocialSecurityNumber = mviPerson[i].SocialSecurityNumber;
                    if (mviPerson[i].StatusCode != null)
                        response.Person[i].StatusCode = mviPerson[i].StatusCode;
                    if (mviPerson[i].IdentifyTheft != null)
                        response.Person[i].IdentifyTheft = mviPerson[i].IdentifyTheft;
                    if (mviPerson[i].Url != null)
                        response.Person[i].Url = mviPerson[i].Url;

                    #endregion PatientPerson General Fields

                    #region booleans never empty fields

                    // Booleans that must return a value...
                    response.Person[i].IsDeceased = mviPerson[i].IsDeceased;

                    #endregion booleans never empty fields

                    if (mviPerson[i].Address != null)
                    {
                        var vetAddr = mviMapPatientAddress(mviPerson[i].Address);
                        response.Person[i].Address = new PatientAddress();

                        if (vetAddr.City != null)
                            response.Person[i].Address.City = vetAddr.City;
                        if (vetAddr.Country != null)
                            response.Person[i].Address.Country = vetAddr.Country;
                        if (vetAddr.StreetAddressLine != null)
                            response.Person[i].Address.StreetAddressLine = vetAddr.StreetAddressLine;
                        if (vetAddr.State != null)
                            response.Person[i].Address.State = vetAddr.State;
                        if (vetAddr.PostalCode != null)
                            response.Person[i].Address.PostalCode = vetAddr.PostalCode;

                        var tempEnum = Enum.Parse(typeof(PatientAddress.AddressUse), vetAddr.Use.ToString()).ToString();
                        response.Person[i].Address.Use = (PatientAddress.AddressUse)Enum.Parse(typeof(PatientAddress.AddressUse), tempEnum);

                        response.Person[i].FullAddress = string.Concat(response.Person[i].Address.StreetAddressLine != null ? response.Person[i].Address.StreetAddressLine.ToString() + ", " : "",
                                                                        response.Person[i].Address.City != null ? response.Person[i].Address.City.ToString() + ", " : "",
                                                                        response.Person[i].Address.State != null ? response.Person[i].Address.State.ToString() + " " : "",
                                                                        response.Person[i].Address.PostalCode != null ? response.Person[i].Address.PostalCode.ToString() : "");
                    }

                    if (mviPerson[i].NameList != null)
                    {
                        var nameList = mviMapName(mviPerson[i].NameList);

                        // Building in the foundation for support for multiple names 
                        int n = 0;
                        response.Person[i].NameList = new Name[1];
                        response.Person[i].NameList[n] = new Name();

                        if (nameList[n].GivenName != null)
                            response.Person[i].NameList[n].GivenName = nameList[n].GivenName;
                        if (nameList[n].MiddleName != null)
                            response.Person[i].NameList[n].MiddleName = nameList[n].MiddleName;
                        if (nameList[n].FamilyName != null)
                            response.Person[i].NameList[n].FamilyName = nameList[n].FamilyName;
                        if (nameList[n].NamePrefix != null)
                            response.Person[i].NameList[n].NamePrefix = nameList[n].NamePrefix;
                        if (nameList[n].NameSuffix != null)
                            response.Person[i].NameList[n].NameSuffix = nameList[n].NameSuffix;
                    }


                    response.Person[i].FullName = string.Concat(string.IsNullOrEmpty(response.Person[i].NameList[0].NamePrefix) ? "" : response.Person[i].NameList[0].NamePrefix + " ",
                                                      string.IsNullOrEmpty(response.Person[i].NameList[0].GivenName) ? "" : response.Person[i].NameList[0].GivenName + " ",
                                                      string.IsNullOrEmpty(response.Person[i].NameList[0].MiddleName) ? "" : response.Person[i].NameList[0].MiddleName + " ",
                                                      string.IsNullOrEmpty(response.Person[i].NameList[0].FamilyName) ? "" : response.Person[i].NameList[0].FamilyName + " ",
                                                      string.IsNullOrEmpty(response.Person[i].NameList[0].NameSuffix) ? "" : response.Person[i].NameList[0].NameSuffix);
                }
            }
        }

        private List<Name> mviMapName(Service.DataStubServiceReference.Name[] mviName)
        {
            List<Name> responseNameList = new List<Name>();

            //nameslist - readonly
            if (mviName != null)
            {
                for (int i = 0; i < mviName.Length; i++)
                {
                    Name newName = new Name();
                    // create a placeholder for the new record

                    switch (mviName[i].Use.ToString())
                    {
                        case "Unspecified": //Unspecified
                            newName.Use = Name.NameUse.Unspecified;
                            break;
                        case "Assigned": //Assigned
                            newName.Use = Name.NameUse.Assigned;
                            break;
                        case "Certificate": //Certificate
                            newName.Use = Name.NameUse.Certificate;
                            break;
                        case "OfficialRegistry": //OfficialRegistry
                            newName.Use = Name.NameUse.OfficialRegistry;
                            break;
                        case "Indigenous": //Indigenous
                            newName.Use = Name.NameUse.Indigenous;
                            break;
                        case "Legal": //Legal
                            newName.Use = Name.NameUse.Legal;
                            break;
                        case "Pseudoymn": //Pseudoymn
                            newName.Use = Name.NameUse.Pseudoymn;
                            break;
                        case "Religous": //Religious
                            newName.Use = Name.NameUse.Religous;
                            break;
                        case "Maiden": //Maiden
                            newName.Use = Name.NameUse.Maiden;
                            break;
                        case "Alias": //Alias
                            newName.Use = Name.NameUse.Alias;
                            break;

                    }

                    if (newName.Use == Name.NameUse.Legal) // legal 
                    {
                        if (mviName[i].FamilyName != null)
                            newName.FamilyName = mviName[i].FamilyName.ToString();
                        if (mviName[i].GivenName != null)
                            newName.GivenName = mviName[i].GivenName.ToString();
                        if (mviName[i].MiddleName != null)
                            newName.MiddleName = mviName[i].MiddleName.ToString();
                        if (mviName[i].NamePrefix != null)
                            newName.NamePrefix = mviName[i].NamePrefix.ToString();
                        if (mviName[i].NameSuffix != null)
                            newName.NameSuffix = mviName[i].NameSuffix.ToString();
                        if (mviName[i].NameType != null)
                            newName.NameType = mviName[i].NameType.ToString();

                        responseNameList.Add(newName);
                    }
                }

                if (responseNameList.Count <= 0)
                {
                    Name newName = new Name();
                    // There was not a legal name so use whatever is the first in the list. Null has already been tested for.
                    if (mviName[0].FamilyName != null)
                        newName.FamilyName = mviName[0].FamilyName.ToString();
                    if (mviName[0].GivenName != null)
                        newName.GivenName = mviName[0].GivenName.ToString();
                    if (mviName[0].MiddleName != null)
                        newName.MiddleName = mviName[0].MiddleName.ToString();
                    if (mviName[0].NamePrefix != null)
                        newName.NamePrefix = mviName[0].NamePrefix.ToString();
                    if (mviName[0].NameSuffix != null)
                        newName.NameSuffix = mviName[0].NameSuffix.ToString();
                    if (mviName[0].NameType != null)
                        newName.NameType = mviName[0].NameType.ToString();

                    responseNameList.Add(newName);
                }
            }

            return responseNameList;
        }

        private PatientAddress mviMapPatientAddress(Service.DataStubServiceReference.PatientAddress mviPatientAddress)
        {
            PatientAddress responseAddress = new PatientAddress();

            // Set the items that have to have another call to crm
            //btsss_address
            if (mviPatientAddress != null)
            {
                // Map the fields
                if (mviPatientAddress != null)
                    responseAddress.Country = mviPatientAddress.Country.ToString();
                if (mviPatientAddress != null)
                    responseAddress.City = mviPatientAddress.City.ToString();
                if (mviPatientAddress != null)
                    responseAddress.PostalCode = mviPatientAddress.PostalCode.ToString();
                if (mviPatientAddress != null)
                    responseAddress.State = mviPatientAddress.State.ToString();
                if (mviPatientAddress != null)
                    responseAddress.StreetAddressLine = mviPatientAddress.StreetAddressLine.ToString();

                #region Never Null fields
                switch (mviPatientAddress.Use.ToString())
                {
                    case "Unspecified": // Unspecified
                        responseAddress.Use = PatientAddress.AddressUse.Unspecified;
                        break;
                    case "Bad": // Bad
                        responseAddress.Use = PatientAddress.AddressUse.Bad;
                        break;
                    case "Confidential": // Confidential
                        responseAddress.Use = PatientAddress.AddressUse.Confidential;
                        break;
                    case "Home": // Home
                        responseAddress.Use = PatientAddress.AddressUse.Home;
                        break;
                    case "PrimaryHome": // PrimaryHome
                        responseAddress.Use = PatientAddress.AddressUse.PrimaryHome;
                        break;
                    case "OtherHome": // OtherHome
                        responseAddress.Use = PatientAddress.AddressUse.OtherHome;
                        break;
                    case "Temporary": // Temporary
                        responseAddress.Use = PatientAddress.AddressUse.Temporary;
                        break;
                    case "Workplace": // Workplace
                        responseAddress.Use = PatientAddress.AddressUse.Workplace;
                        break;
                    case "Other": // Other
                        responseAddress.Use = PatientAddress.AddressUse.Other;
                        break;
                }
                #endregion Never Null fields
            }
            return responseAddress;
        }

        //private Address GetPrimaryAddress(PatientAddress mviAddress)
        //{
        //    Address responseAddress = new Address();

        //    if (mviAddress.City != null)
        //        responseAddress.City = mviAddress.City;
        //    if (mviAddress.Country != null)
        //        responseAddress.Country = mviAddress.Country;
        //    if (mviAddress.StreetAddressLine != null)
        //        responseAddress.Line1 = mviAddress.StreetAddressLine;
        //    if (mviAddress.State != null)
        //        responseAddress.State = mviAddress.State;
        //    if (mviAddress.PostalCode != null)
        //        responseAddress.Zip = mviAddress.PostalCode;

        //    responseAddress.Use = (Address.AddressType)mviAddress.Use;

        //    return responseAddress;
        //}

        #endregion MVI Integration Region
    }
}
