﻿using System;
using System.ComponentModel.Composition;
using VIMT.Integrations.MVI.Messages;
using VIMT.Integrations.MVI.WebService.Processors;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.MVI.WebService.Handlers
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.RetrieveWithOrchestrationRequest)]
    public class MVIHandler : RequestResponseHandler
    {
        public override IMessageBase HandleRequestResponse(object message)
    {
        try
        {
            var MVIMessage = message as RetrieveWithOrchestrationRequest;
            if (MVIMessage != null)
            {
                LogMessageReceipt(MVIMessage);
                return new MVIProcessor().Execute(MVIMessage);
            }
            return null;
        }
        catch (Exception ex)
        {
            //Log exception and rethrow
            Logger.Instance.Error("Exception from MVI Handler", ex);
            throw;
        }
    }
}
}
