﻿using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIMT.Integrations.MVI.Service.Configuration;
using VIMT.Integrations.MVI.Service.DataStubServiceReference;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.MVI.Service.Wcf
{
    public class ServiceFactory
    {
        // Uses IMS Endopint to point to the service this example uses parameters passed in
        public static IDataStubService GetAppealServiceReference(IOrganizationService organizationService, Guid userId)
        {
            var channel = new ServiceCustomClientChannel<IDataStubService>("BasicHttpBinding_IDataStubService", ConfigurationLocation.GetConfigFilePath("EC"));

            channel.Endpoint.AddSecurityHeader(organizationService, userId);

            SoapLog.Current.Active = MviStubConfiguration.Current.EnableLogging;

            return channel.CreateChannel();
        }

        // Uses IMS Endopint to point to the service this example uses a header record
        public static IDataStubService GetAppealServiceReference(HeaderInfo headerInfo)
        {
            var channel = new ServiceCustomClientChannel<IDataStubService>("BasicHttpBinding_IDataStubService", ConfigurationLocation.GetConfigFilePath("EC"));

            channel.Endpoint.AddSecurityHeader(headerInfo);

            SoapLog.Current.Active = MviStubConfiguration.Current.EnableLogging;

            return channel.CreateChannel();
        }

        // Uses IMS Endopint to point to the service this example does not use a header record.
        public static IDataStubService GetAppealServiceReference()
        {
            var channel = new ServiceCustomClientChannel<IDataStubService>("BasicHttpBinding_IDataStubService", ConfigurationLocation.GetConfigFilePath("EC"));

            return channel.CreateChannel();
        }
    }
}
