﻿using System;
using VIMT.Integrations.FMS.Messages;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;

namespace VIMT.Integrations.FMS.WebService.Processors
{
    public class BankInformationProcessor
    {
        public LoadBankInformationResponse Execute(LoadBankInformationRequest request)
        {
            try
            {
                LoadBankInformationResponse response = new LoadBankInformationResponse();
                //Invoke the processor here..and fill up the response object
                Service.DataStubServiceReference.VeteranBankInformationRequest serviceRequest = new Service.DataStubServiceReference.VeteranBankInformationRequest();
                serviceRequest.EdiPi = request.EdiPi;
                serviceRequest.PatientIdentifier = request.PatientIdentifier;
                serviceRequest.OrganizationName = request.OrganizationName;
                serviceRequest.UserFirstName = request.UserFirstName;
                serviceRequest.UserId = request.UserId;
                serviceRequest.UserLastName = request.UserLastName;

                var proxy = Service.Wcf.ServiceFactory.GetAppealServiceReference();
                var stubResponse = proxy.getVeteranBankInformation(serviceRequest);

                if (stubResponse != null)
                    response = MapBankInformationResponse(stubResponse);


                return response;
            }
            catch (NetworkOperationCancelledException ex)
            {
                if (ex.InnerException.ToString().Contains("There was no endpoint listening"))
                {
                    throw new InvalidOperationException(ex.InnerException.ToString());
                }
                else
                {
                    throw new NetworkOperationCancelledException(ex.Message);
                }
            }
            catch (Exception ex)
            {
                if (ex.InnerException != null)
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "BankInformationProcessor, Execute", "Exception:" + ex.Message + ex.InnerException.ToString());
                }
                else
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "BankInformationProcessor, Execute", "Exception:" + ex.Message + "No Inner Exception Text");
                }

                if (ex.Message.Contains("No Endpoint Listening"))
                {
                    throw new NetworkOperationCancelledException(ex.InnerException.ToString());
                }
                else
                {
                    throw new InvalidOperationException(ex.Message.ToString());
                }
            }

        }

        public LoadBankInformationResponse MapBankInformationResponse(Service.DataStubServiceReference.VeteranBankInformationResponse stubResponse)
        {
            LoadBankInformationResponse response = new LoadBankInformationResponse();

            if (stubResponse.PatientIdentifier != null)
                response.PatientIdentifier = stubResponse.PatientIdentifier;
            if (stubResponse.BankAccountNumber != null)
                response.BankAccountNumber = stubResponse.BankAccountNumber;
            if (stubResponse.BankAccountType != null)
                response.BankAccountType = stubResponse.BankAccountType;
            if (stubResponse.BankRoutingNumber != null)
                response.BankRoutingNumber = stubResponse.BankRoutingNumber;
            if (stubResponse.Message != null)
                response.Message = stubResponse.Message;
            if (stubResponse.OrganizationName != null)
                response.OrganizationName = stubResponse.OrganizationName;

            response.ExceptionOccured = stubResponse.ExceptionOccured;

            return response;
        }
    }
}
