﻿using System;
using System.ComponentModel.Composition;
using VIMT.Integrations.FMS.Messages;
using VIMT.Integrations.FMS.WebService.Processors;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.FMS.WebService.Handlers
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.LoadBankInformationRequest)]
    public class BankInformationHandler : RequestResponseHandler
    {
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                var BankInformationMessage = message as LoadBankInformationRequest;
                if (BankInformationMessage != null)
                {
                    LogMessageReceipt(BankInformationMessage);
                    return new BankInformationProcessor().Execute(BankInformationMessage);
                }
                return null;
            }
            catch (Exception ex)
            {
                //Log exception and rethrow
                Logger.Instance.Error("Exception from BankInformationHandler", ex);
                throw;
            }
        }
    }
}
