﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.FMS.Service.Configuration
{
    [Serializable]
    public class BankInformationConfiguration : ObjectConfigHandler
    {
        public BankInformationConfiguration()
        { }

        public static BankInformationConfiguration Current
        {
            get
            {
                var configurationFileReader = new CustomConfigurationFileReader();

                var section = configurationFileReader.GetCustomConfig<BankInformationConfiguration>(ConfigurationLocation.ConfigDefiningAssemblyPath, ConfigurationLocation.GetConfigFilePath("EC"), "BankInformationConfiguration");

                if (section == null)
                {
                    throw new Exception("Cannot find FMS integration configuration");
                }
                return section;
            }
        }

        // These entries correspond to entries in the ec.config file. this is a generic expample that might be used for your service.
        // In the real service you only want to use fields that are necessary.
        // These are read in by VIMT when you call the GetCustomConfig

        public string UserName { get; set; }
        public string Password { get; set; }
        public string ClientMachine { get; set; }
        public string StnId { get; set; }
        public string ApplicationId { get; set; }
        public bool RequiresClientCertificate { get; set; }
        public string ClientCertificateName { get; set; }
        public bool EnableLogging { get; set; }
    }
}
