﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.FMS.Messages
{
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.LoadBankInformationRequest)]
    [DataContract]
    public class LoadBankInformationRequest : MessageBase
    {
        [DataMember]
        public string PatientIdentifier { get; set; }
        [DataMember]
        public string EdiPi { get; set; }
        [DataMember]
        public string OrganizationName { get; set; }
        [DataMember]
        public string UserFirstName { get; set; }
        [DataMember]
        public string UserLastName { get; set; }
        [DataMember]
        public Guid UserId { get; set; }
    }
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.LoadBankInformationResponse)]
    [DataContract]
    public class LoadBankInformationResponse : MessageBase
    {
        [DataMember]
        public string PatientIdentifier { get; set; }
        [DataMember]
        public string BankRoutingNumber { get; set; }
        [DataMember]
        public string BankAccountNumber { get; set; }
        [DataMember]
        public string BankAccountType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public Boolean ExceptionOccured { get; set; }
        [DataMember]
        public string OrganizationName { get; set; }
    }
}
