﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIMT.Integrations.ES.Messages;
using VIMT.Integrations.ES.WebService.Processors;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.ES.WebService.Handlers
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VIMTLOADESREQUEST)]
    public class ESHandler : RequestResponseHandler
    {
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                var ESMessage = message as LoadESRequest;
                if (ESMessage != null)
                {
                    LogMessageReceipt(ESMessage);
                    return new ESProcessor().Execute(ESMessage);
                }
                return null;
            }
            catch (Exception ex)
            {
                //Log exception and rethrow
                Logger.Instance.Error("Exception from ESHandler", ex);
                throw;
            }
        }
    }
}
