﻿using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIMT.Integrations.ES.Service.Configuration;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.ES.Service.Wcf
{
    public class ServiceFactory
    {
        public static UserProfileClient GetAppealServiceReference(IOrganizationService organizationService, Guid userId)
        {
            var channel = new ServiceCustomClientChannel<UserProfileClient>("UserProfile", ConfigurationLocation.GetConfigFilePath("EC"));

            channel.Endpoint.AddSecurityHeader(organizationService, userId);

            SoapLog.Current.Active = ESConfiguration.Current.EnableLogging;

            return channel.CreateChannel();
        }

        public static UserProfileClient GetAppealServiceReference(HeaderInfo headerInfo)
        {
            var channel = new ServiceCustomClientChannel<UserProfileClient>("UserProfile", ConfigurationLocation.GetConfigFilePath("EC"));

            channel.Endpoint.AddSecurityHeader(headerInfo);

            SoapLog.Current.Active = ESConfiguration.Current.EnableLogging;

            return channel.CreateChannel();
        }
    }
}
