﻿using Microsoft.Xrm.Tooling.Connector;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections;
using System.Collections.Generic;
using VRM.Integration.Servicebus.Core;
using DataStub.Services;

namespace IMSDataStub.Services.MessageMaps
{
    public static class getVeteranNetIncome
    {
        public static CrmServiceClient _serviceProxy { get; set; }
        public static Guid _userId { get; set; }

        public static VeteranNetIncomeResponse BuildMessageResponse(VeteranNetIncomeRequest request, CrmServiceClient crmSrv)
        {
            _serviceProxy = crmSrv;

            VeteranNetIncomeResponse response = new VeteranNetIncomeResponse();

            // Go to CRM and Get the top level response object based on the request Patient ID
            QueryByAttribute qba = new QueryByAttribute("btsss_veterannetincomerequest");
            qba.ColumnSet = new ColumnSet(true);
            qba.Attributes.AddRange("btsss_patientidentifier");
            qba.Values.AddRange(request.PatientIdentifier);
            var returnValue = _serviceProxy.RetrieveMultiple(qba);


            if (returnValue != null && returnValue.Entities.Count == 1)
            {
                Entity ent = returnValue.Entities[0];

                if (ent.Attributes["btsss_patientidentifier"].Equals(request.PatientIdentifier) == true)
                {
                    // Get the response data
                    Entity retrieveNetIncome = _serviceProxy.Retrieve("btsss_veterannetincomeresponse", ((EntityReference)ent.Attributes["btsss_veterannetincomeresponse"]).Id, new ColumnSet(true));

                    if (retrieveNetIncome == null)
                    {
                        response.Message = "No Net Income information found for Veteran";
                        response.ExceptionOccured = true;
                        return response;
                    }

                    response = MapVeteranNetIncome(retrieveNetIncome);
                    return response;
                }
                else
                {
                    response.Message = returnValue.Entities.Count.ToString() + " - Veteran Net Income Records were returned. None of them met the identifier type criteria";
                }
            }
            else
            {
                // There were not any person records that meet the passed in informtion
                response.ExceptionOccured = false;
                response.OrganizationName = request.OrganizationName;
                response.Message = returnValue.Entities.Count.ToString() + " - Veteran Net Income Records were returned.";

            }
            return response;
        }

        public static VeteranNetIncomeResponse MapVeteranNetIncome(Entity ent)
        {
            VeteranNetIncomeResponse response = new VeteranNetIncomeResponse();
            if(ent.Attributes.Contains("btsss_edipi") && ent.Attributes["btsss_edipi"] != null)
                response.EdiPi = ent.Attributes["btsss_edipi"].ToString();
            if (ent.Attributes.Contains("btsss_incomeexpiration") && ent.Attributes["btsss_incomeexpiration"] != null)
                response.IncomeExpiration = Convert.ToDateTime(ent.Attributes["btsss_incomeexpiration"].ToString());
            if (ent.Attributes.Contains("btsss_incomemodifiedby") && ent.Attributes["btsss_incomemodifiedby"] != null)
                response.IncomeModifiedBy = new Guid(((EntityReference)ent.Attributes["btsss_incomemodifiedby"]).Id.ToString());
            if (ent.Attributes.Contains("btsss_incomemodifiedon") && ent.Attributes["btsss_incomemodifiedon"] != null)
                response.IncomeModifiedOn = Convert.ToDateTime(ent.Attributes["btsss_incomemodifiedon"].ToString());
            if (ent.Attributes.Contains("btsss_incomesource") && ent.Attributes["btsss_incomesource"] != null)
                response.IncomeSource = ent.Attributes["btsss_incomesource"].ToString();
            if (ent.Attributes.Contains("btsss_netincome") && ent.Attributes["btsss_netincome"] != null)
                response.NetIncome = ent.Attributes["btsss_netincome"].ToString();
            if (ent.Attributes.Contains("btsss_oldnetincome") && ent.Attributes["btsss_oldnetincome"] != null)
                response.OldNetIncome = ent.Attributes["btsss_oldnetincome"].ToString();
            if (ent.Attributes.Contains("btsss_patientidentifier") && ent.Attributes["btsss_patientidentifier"] != null)
                response.PatientIdentifier = ent.Attributes["btsss_patientidentifier"].ToString();

            return response;
        }
    }
}