﻿using Microsoft.Xrm.Tooling.Connector;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections;
using System.Collections.Generic;
using VRM.Integration.Servicebus.Core;
using DataStub.Services;

namespace DataStub.Services.MessageMaps
{
    public static class MVIPersonSearchMessageMap
    {
        public static CrmServiceClient _serviceProxy { get; set; }
        public static Guid _userId { get; set; }

        // Build out the response message from the top of the treee and work out at each data member at the top level.
        public static RetrieveOrSearchPersonResponse BuildMessageResponse(RetrieveWithOrchestrationRequest request, CrmServiceClient crmSrv)
        {
            _serviceProxy = crmSrv;
            _userId = request.UserId;

            RetrieveOrSearchPersonResponse response = new RetrieveOrSearchPersonResponse();

            // Go to CRM and Get the top level response object based on the request Patient ID
            QueryByAttribute qba = new QueryByAttribute("btsss_patientperson");
            qba.ColumnSet = new ColumnSet(true);
            qba.Attributes.AddRange("btsss_participantid");
            qba.Values.AddRange(request.PatientIdentifier);
            var returnValue = _serviceProxy.RetrieveMultiple(qba);

            if(returnValue != null && returnValue.Entities.Count > 0)
            {
                List<PatientPerson> personRecords = new List<PatientPerson>();

                foreach (Entity ent in returnValue.Entities)
                {
                    //if (request.IdentifierType.Equals(IMSDataStub.Services.Utilities.DataStubUtilities.getOptionSetString(((OptionSetValue)ent.Attributes["btsss_identifiertype"]).Value, ent.LogicalName, "btsss_identifiertype", _serviceProxy)) == true)
                    if (request.IdentifierType.Equals(IMSDataStub.Services.Utilities.DataStubUtilities.getOptionSetString(((OptionSetValue)ent.Attributes["btsss_identifiertype"]).Value, ent.LogicalName, "btsss_identifiertype", _serviceProxy)) == true)
                    {
                        PatientPerson newPerson = new PatientPerson();
                        // create a placeholder for the new record
                        newPerson = mviMapPatient(ent);

                        personRecords.Add(newPerson);
                    }

                }

                if ( personRecords.Count != 0)
                {
                    response.Person = personRecords.ToArray();
                }
                else
                {
                    response.Message = personRecords.Count.ToString() + " - Person Records were returned but none of them met the identifier type criteria";
                }
            }
            else
            {
                // There were not any person records that meet the passed in informtion
                response.ExceptionOccured = false;
                response.OrganizationName = request.OrganizationName;
                response.Message = "No person records were returned.";
            }

            // Close the connections.
            crmSrv = null;
            _serviceProxy = null;

            if (response.Acknowledgement == null)
                response.Acknowledgement = new Acknowledgement();
            if (response.Message == null)
                response.Message = "OK";
            if (response.OrganizationName == null)
                response.OrganizationName = "IMS";
            if (response.QueryAcknowledgement == null)
                response.QueryAcknowledgement = new QueryAcknowledgement();
            if (response.RawMviExceptionMessage == null)
                response.RawMviExceptionMessage = string.Empty;


            return response;
        }

        private static PatientPerson mviMapPatient(Entity ent)
        {
            #region PatientPerson General Fields
            PatientPerson returnPerson = new PatientPerson();

            // Set the top level single items first
            if(ent.Attributes.Contains("btsss_birthdate") && ent.Attributes["btsss_birthdate"] != null)
                returnPerson.BirthDate = ent.Attributes["btsss_birthdate"].ToString();
            if (ent.Attributes.Contains("btsss_deceaseddate") && ent.Attributes["btsss_deceaseddate"] != null)
                returnPerson.DeceasedDate = ent.Attributes["btsss_deceaseddate"].ToString();
            if (ent.Attributes.Contains("btsss_edipi") && ent.Attributes["btsss_edipi"] != null)
                returnPerson.EdiPi = ent.Attributes["btsss_edipi"].ToString();
            if (ent.Attributes.Contains("btsss_gendercode") && ent.Attributes["btsss_gendercode"] != null)
                returnPerson.GenderCode = ent.Attributes["btsss_gendercode"].ToString();
            if (ent.Attributes.Contains("btsss_identifier") && ent.Attributes["btsss_identifier"] != null)
                returnPerson.Identifier = ent.Attributes["btsss_identifier"].ToString();
            if (ent.Attributes.Contains("btsss_identifiertype") && ent.Attributes["btsss_identifiertype"] != null)
                returnPerson.IdentifierType = IMSDataStub.Services.Utilities.DataStubUtilities.getOptionSetString(((OptionSetValue)ent.Attributes["btsss_identifiertype"]).Value, ent.LogicalName, "btsss_identifiertype", _serviceProxy);
            if (ent.Attributes.Contains("btsss_participantid") && ent.Attributes["btsss_participantid"] != null)
                returnPerson.ParticipantId = ent.Attributes["btsss_participantid"].ToString();
            if (ent.Attributes.Contains("btsss_phonenumber") && ent.Attributes["btsss_phonenumber"] != null)
                returnPerson.PhoneNumber = ent.Attributes["btsss_phonenumber"].ToString();
            if (ent.Attributes.Contains("btsss_recordsource") && ent.Attributes["btsss_recordsource"] != null)
                returnPerson.RecordSource = ent.Attributes["btsss_recordsource"].ToString();
            if (ent.Attributes.Contains("btsss_socialsecuritynumber") && ent.Attributes["btsss_socialsecuritynumber"] != null)
                returnPerson.SocialSecurityNumber = ent.Attributes["btsss_socialsecuritynumber"].ToString();
            if (ent.Attributes.Contains("btsss_statuscode") && ent.Attributes["btsss_statuscode"] != null)
                returnPerson.StatusCode = ent.Attributes["btsss_statuscode"].ToString();
            if (ent.Attributes.Contains("btsss_url") && ent.Attributes["btsss_url"] != null)
                returnPerson.Url = ent.Attributes["btsss_url"].ToString();

            #endregion PatientPerson General Fields

            #region booleans never empty fields

            // Booleans that must return a value...
            if (ent.Attributes.Contains("btsss_identitytheft") && ent.Attributes["btsss_identitytheft"] != null)
            {
                returnPerson.IdentifyTheft = ent.Attributes["btsss_identitytheft"].ToString();
            }
            else
            {
                returnPerson.IdentifyTheft = "false";
            }
            if (ent.Attributes.Contains("btsss_isdeceased") && ent.Attributes["btsss_isdeceased"] != null)
            {
                bool result = false;
                var parsedValue = bool.TryParse(ent.Attributes["btsss_isdeceased"].ToString(), out result);
                if (result)
                {
                    returnPerson.IsDeceased = parsedValue;
                }

            }
            else
            {
                returnPerson.IsDeceased = false;
            }
            #endregion booleans never empty fields

            #region address
            // Set the items that have to have another call to crm
            //btsss_address
            if (ent.Attributes.Contains("btsss_address") && ent.Attributes["btsss_address"] != null)
            {
                PatientAddress newAddress = new PatientAddress();

                Entity addressEntity = _serviceProxy.Retrieve("btsss_patientaddress", new Guid(((EntityReference)ent.Attributes["btsss_address"]).Id.ToString()), new ColumnSet(true));

                if (addressEntity != null)
                {
                    // Map the fields
                    if (addressEntity.Attributes.Contains("btsss_country") && addressEntity.Attributes["btsss_country"] != null)
                        newAddress.Country = addressEntity.Attributes["btsss_country"].ToString();
                    if (addressEntity.Attributes.Contains("btsss_city") && addressEntity.Attributes["btsss_city"] != null)
                        newAddress.City = addressEntity.Attributes["btsss_city"].ToString();
                    if (addressEntity.Attributes.Contains("btsss_postalcode") && addressEntity.Attributes["btsss_postalcode"] != null)
                        newAddress.PostalCode = addressEntity.Attributes["btsss_postalcode"].ToString();
                    if (addressEntity.Attributes.Contains("btsss_state") && addressEntity.Attributes["btsss_state"] != null)
                        newAddress.State = addressEntity.Attributes["btsss_state"].ToString();
                    if (addressEntity.Attributes.Contains("btsss_streetaddressline") && addressEntity.Attributes["btsss_streetaddressline"] != null)
                        newAddress.StreetAddressLine = addressEntity.Attributes["btsss_streetaddressline"].ToString();

                    if (addressEntity.Attributes.Contains("btsss_use") && addressEntity.Attributes["btsss_use"] != null)
                    {
                        switch (addressEntity.Attributes["btsss_use"].ToString())
                        {
                            case "421750000": // Unspecified
                                newAddress.Use = PatientAddress.AddressUse.Unspecified;
                                break;
                            case "421750001": // Bad
                                newAddress.Use = PatientAddress.AddressUse.Bad;
                                break;
                            case "421750002": // Confidential
                                newAddress.Use = PatientAddress.AddressUse.Confidential;
                                break;
                            case "421750003": // Home
                                newAddress.Use = PatientAddress.AddressUse.Home;
                                break;
                            case "421750004": // PrimaryHome
                                newAddress.Use = PatientAddress.AddressUse.PrimaryHome;
                                break;
                            case "421750005": // OtherHome
                                newAddress.Use = PatientAddress.AddressUse.OtherHome;
                                break;
                            case "421750006": // Temporary
                                newAddress.Use = PatientAddress.AddressUse.Temporary;
                                break;
                            case "421750007": // Workplace
                                newAddress.Use = PatientAddress.AddressUse.Workplace;
                                break;
                            case "421750008": // Other
                                newAddress.Use = PatientAddress.AddressUse.Other;
                                break;
                        }
                    }

                    returnPerson.Address = newAddress;
                    returnPerson.FullAddress = GetFullAddress(newAddress);
                }
            }
            #endregion address

            #region Corresponding IDs UnattendedSearchRequest
            //correspondingidlist
            if (ent.Attributes.Contains("btsss_correspondingidlist") && ent.Attributes["btsss_correspondingidlist"] != null)
            {
                QueryByAttribute qbaCorrelatedIds = new QueryByAttribute("btsss_unattendedsearchrequest");
                qbaCorrelatedIds.ColumnSet = new ColumnSet(true);
                qbaCorrelatedIds.Attributes.AddRange("btsss_unattendedsearchrequestid");
                qbaCorrelatedIds.Values.AddRange(new Guid(((EntityReference)ent.Attributes["btsss_correspondingidlist"]).Id.ToString()));
                var correlatedIdEntity = _serviceProxy.RetrieveMultiple(qbaCorrelatedIds);

                if (correlatedIdEntity != null && correlatedIdEntity.Entities.Count > 0)
                {
                    List<UnattendedSearchRequest> correlatedRecords = new List<UnattendedSearchRequest>();

                    foreach (Entity correlatedEnt in correlatedIdEntity.Entities)
                    {
                        UnattendedSearchRequest newCorrelatedId = new UnattendedSearchRequest();
                        // create a placeholder for the new record
                        newCorrelatedId = mapCorrelatedIs(correlatedEnt);

                        correlatedRecords.Add(newCorrelatedId);
                    }

                    returnPerson.CorrespondingIdList = correlatedRecords.ToArray();
                }
                else
                {
                    // Do nothing... correlated Ids do not have to be filled in yet
                }
            }
            #endregion Corresponding IDs UnattendedSearchRequest

            #region namelist
            //nameslist - readonly
            if (ent.Attributes.Contains("btsss_namelist") && ent.Attributes["btsss_namelist"] != null)
            {
                List<Name> namelistRecords = new List<Name>();

                QueryByAttribute qbaName = new QueryByAttribute("btsss_name");
                qbaName.ColumnSet = new ColumnSet(true);
                qbaName.Attributes.AddRange("btsss_nameid");
                qbaName.Values.AddRange(new Guid(((EntityReference)ent.Attributes["btsss_namelist"]).Id.ToString()));
                var nameRecords = _serviceProxy.RetrieveMultiple(qbaName);

                if (nameRecords != null)
                {
                    foreach (Entity nameEnt in nameRecords.Entities)
                    {
                        Name newName = new Name();
                        // create a placeholder for the new record
                        newName = mviMapNames(nameEnt);

                        namelistRecords.Add(newName);
                    }

                    if (namelistRecords.Count != 0)
                    {
                        returnPerson.NameList = namelistRecords.ToArray();
                        returnPerson.FullName = string.Concat(string.IsNullOrEmpty(namelistRecords[0].GivenName) ? string.Empty : namelistRecords[0].GivenName,
                                                string.IsNullOrWhiteSpace(namelistRecords[0].MiddleName) ? "" : " " + namelistRecords[0].MiddleName,
                                                string.IsNullOrWhiteSpace(namelistRecords[0].FamilyName) ? "" : " " + namelistRecords[0].FamilyName);
                    }
                }
            }
            #endregion namelist

            return returnPerson;
        }

        #region mapping
        private static string GetFullAddress(PatientAddress newAddress)
        {
            if (newAddress == null)
            {
                return string.Empty;
            }

            const string addressFormat = "{0} {1} {2} {3}";
            object[] addressArrary =
            {
                    newAddress.StreetAddressLine, newAddress.City, newAddress.State, newAddress.PostalCode
                };
            var address = string.Format(addressFormat, addressArrary);

            return address;
        }

        private static UnattendedSearchRequest mapCorrelatedIs(Entity correlatedIdEntity)
        {
            UnattendedSearchRequest newCorrelatedId = new UnattendedSearchRequest();
            // Map the fields
            if (correlatedIdEntity.Attributes.Contains("btsss_assigningauthority") && correlatedIdEntity.Attributes["btsss_assigningauthority"] != null)
                newCorrelatedId.AssigningAuthority = correlatedIdEntity.Attributes["btsss_assigningauthority"].ToString();
            if (correlatedIdEntity.Attributes.Contains("btsss_assigningfacility") && correlatedIdEntity.Attributes["btsss_assigningfacility"] != null)
                newCorrelatedId.AssigningFacility = correlatedIdEntity.Attributes["btsss_assigningfacility"].ToString();
            if (correlatedIdEntity.Attributes.Contains("btsss_authorityoid") && correlatedIdEntity.Attributes["btsss_authorityoid"] != null)
                newCorrelatedId.AuthorityOid = correlatedIdEntity.Attributes["btsss_authorityoid"].ToString();
            if (correlatedIdEntity.Attributes.Contains("btsss_fetchmessageprocess") && correlatedIdEntity.Attributes["btsss_fetchmessageprocess"] != null)
            {
                switch (correlatedIdEntity.Attributes["btsss_fetchmessageprocess"].ToString())
                {
                    case "Local":
                        newCorrelatedId.FetchMessageProcessType = MessageProcessType.Local;
                        break;
                    case "Remote":
                        newCorrelatedId.FetchMessageProcessType = MessageProcessType.Remote;
                        break;
                    case "RemoteQueued":
                        newCorrelatedId.FetchMessageProcessType = MessageProcessType.RemoteQueued;
                        break;
                }
            }

            if (correlatedIdEntity.Attributes.Contains("btsss_identifiertype") && correlatedIdEntity.Attributes["btsss_identifiertype"] != null)
                newCorrelatedId.IdentifierType = correlatedIdEntity.Attributes["btsss_identifiertype"].ToString();
            if (correlatedIdEntity.Attributes.Contains("btsss_organizationname") && correlatedIdEntity.Attributes["btsss_organizationname"] != null)
                newCorrelatedId.OrganizationName = correlatedIdEntity.Attributes["btsss_organizationname"].ToString();
            if (correlatedIdEntity.Attributes.Contains("btsss_patientidentifiery") && correlatedIdEntity.Attributes["btsss_patientidentifiery"] != null)
                newCorrelatedId.PatientIdentifier = correlatedIdEntity.Attributes["btsss_patientidentifiery"].ToString();
            if (correlatedIdEntity.Attributes.Contains("btsss_rawvaluefrommvi") && correlatedIdEntity.Attributes["btsss_rawvaluefrommvi"] != null)
                newCorrelatedId.RawValueFromMvi = correlatedIdEntity.Attributes["btsss_rawvaluefrommvi"].ToString();
            if (correlatedIdEntity.Attributes.Contains("btsss_userawmvivalue") && correlatedIdEntity.Attributes["btsss_userawmvivalue"] != null)
                newCorrelatedId.AssigningAuthority = correlatedIdEntity.Attributes["btsss_userawmvivalue"].ToString();
            if (correlatedIdEntity.Attributes.Contains("btsss_userfirstname") && correlatedIdEntity.Attributes["btsss_userfirstname"] != null)
                newCorrelatedId.UserFirstName = correlatedIdEntity.Attributes["btsss_userfirstname"].ToString();
            if (correlatedIdEntity.Attributes.Contains("btsss_userid") && correlatedIdEntity.Attributes["btsss_userid"] != null)
                newCorrelatedId.UserId = _userId;
            if (correlatedIdEntity.Attributes.Contains("btsss_userlastname") && correlatedIdEntity.Attributes["btsss_userlastname"] != null)
                newCorrelatedId.AssigningAuthority = correlatedIdEntity.Attributes["btsss_userlastname"].ToString();

            return newCorrelatedId;
        }

        private static Name mviMapNames(Entity nameEnt)
        {
            Name returnName = new Name();

            if(nameEnt.Attributes.Contains("btsss_familyname") && nameEnt.Attributes["btsss_familyname"] != null )
                returnName.FamilyName = nameEnt.Attributes["btsss_familyname"].ToString();
            if (nameEnt.Attributes.Contains("btsss_givenname") && nameEnt.Attributes["btsss_givenname"] != null)
                returnName.GivenName = nameEnt.Attributes["btsss_givenname"].ToString();
            if (nameEnt.Attributes.Contains("btsss_middlename") && nameEnt.Attributes["btsss_middlename"] != null)
                returnName.MiddleName = nameEnt.Attributes["btsss_middlename"].ToString();
            if (nameEnt.Attributes.Contains("btsss_nameprefix") && nameEnt.Attributes["btsss_nameprefix"] != null)
                returnName.NamePrefix = nameEnt.Attributes["btsss_nameprefix"].ToString();
            if (nameEnt.Attributes.Contains("btsss_namesuffix") && nameEnt.Attributes["btsss_namesuffix"] != null)
                returnName.NameSuffix = nameEnt.Attributes["btsss_namesuffix"].ToString();
            if (nameEnt.Attributes.Contains("btsss_nametype") && nameEnt.Attributes["btsss_nametype"] != null)
                returnName.NameType = nameEnt.Attributes["btsss_nametype"].ToString();

            if(nameEnt.Attributes.Contains("btsss_use") && nameEnt.Attributes["btsss_use"] != null)
            {
                switch(nameEnt.Attributes["btsss_use"].ToString())
                {
                    case "421750000": // Unspecified = 0
                        returnName.Use = Name.NameUse.Unspecified;
                        break;
                    case "421750001": // Assigned = 1
                        returnName.Use = Name.NameUse.Assigned;
                        break;
                    case "421750002": // Certificate = 2
                        returnName.Use = Name.NameUse.Certificate;
                        break;
                    case "421750003": // OfficialRegistry = 3
                        returnName.Use = Name.NameUse.OfficialRegistry;
                        break;
                    case "421750004": // Indigenous = 4
                        returnName.Use = Name.NameUse.Indigenous;
                        break;
                    case "421750005": // Legal = 5
                        returnName.Use = Name.NameUse.Legal;
                        break;
                    case "421750006": // Pseudoymn = 6
                        returnName.Use = Name.NameUse.Pseudoymn;
                        break;
                    case "421750007": // Religous = 7
                        returnName.Use = Name.NameUse.Religous;
                        break;
                    case "421750008": // Maiden = 8
                        returnName.Use = Name.NameUse.Maiden;
                        break;
                    case "421750009": // Alias = 9
                        returnName.Use = Name.NameUse.Alias;
                        break;

                }
            }
            return returnName;
        }
        #endregion Mapping
    }
}
