﻿using Microsoft.Xrm.Tooling.Connector;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using DataStub.Services;


namespace IMSDataStub.Services.MessageMaps
{
    public class GetVeteranAppointmentDateRange
    {
        public static CrmServiceClient _serviceProxy { get; set; }
        public static Guid _userId { get; set; }

        public static VISTAVeteranAppointmentDateRangeResponse BuildMessageResponse(VISTAVeteranAppointmentDateRangeRequest request, CrmServiceClient crmSrv)
        {
            _serviceProxy = crmSrv;
            string RangeString = string.Empty;
            Boolean IsValidDateRange = false;
            Boolean IsStartDateAvailable = false;
            Boolean IsEndDateAvailable = false;
            VISTAVeteranAppointmentDateRangeResponse response = new VISTAVeteranAppointmentDateRangeResponse();


            // Determine if the date range sent in is valid
            if (request.AppointmentStartDate != null && request.AppointmentEndDate != null && request.AppointmentStartDate > new DateTime(1753, 1, 1) && request.AppointmentEndDate > new DateTime(1753, 1, 1))
            {
                if(request.AppointmentStartDate.Date < request.AppointmentEndDate.Date)
                {
                    IsValidDateRange = true;
                    IsStartDateAvailable = true;
                    IsEndDateAvailable = true;
                }
                else
                {
                    response.DateRangeSearch = "Invalide Date Range";
                    response.ExceptionOccured = true;
                    response.Message = string.Concat("Invalid Date Range requested. StartDate was greater than EndDate. Unable to process Request.");

                    if (!string.IsNullOrEmpty(request.FacilityIdentifier))
                        response.FacilityIdentifier = request.FacilityIdentifier;
                    if (!string.IsNullOrEmpty(request.PatientIdentifier))
                        response.PatientIdentifier = request.PatientIdentifier;
                    if (!string.IsNullOrEmpty(request.OrganizationName))
                        response.OrganizationName = request.OrganizationName;

                    return response;
                }
            }
            else
            {
                if(request.AppointmentStartDate != null && request.AppointmentStartDate > new DateTime(1753, 1, 1))
                {
                    IsValidDateRange = true;
                    IsStartDateAvailable = true;
                }
                if (request.AppointmentEndDate != null && request.AppointmentEndDate > new DateTime(1753, 1, 1))
                {
                    IsValidDateRange = true;
                    IsEndDateAvailable = true;
                }
            }

            response.OrganizationName = request.OrganizationName;
            response.OrganizationName = request.PatientIdentifier;

            // Go to CRM and Get the top level response object based on the request Patient ID
            List<VeteranAppointment> VetAppointments = new List<VeteranAppointment>();
            
            // Go to CRM and Get the top level response object based on the request Patient ID
            QueryExpression qe = new QueryExpression("btsss_veteranappointmentdetail");
            qe.ColumnSet = new ColumnSet(true);
            qe.Criteria = new FilterExpression(LogicalOperator.And);

            if(IsValidDateRange == true && IsStartDateAvailable == true)
            {
                ConditionExpression ce1 = new ConditionExpression();
                ce1.AttributeName = "btsss_appointmentdate";
                ce1.Operator = ConditionOperator.OnOrAfter;
                ce1.Values.Add(request.AppointmentStartDate);

                qe.Criteria.Conditions.Add(ce1);

                RangeString = string.Concat("StartRange: ", request.AppointmentStartDate.ToShortDateString());
            }

            if(IsValidDateRange == true && IsEndDateAvailable == true)
            {
                ConditionExpression ce2 = new ConditionExpression();
                ce2.AttributeName = "btsss_appointmentdate";
                ce2.Operator = ConditionOperator.OnOrBefore;
                ce2.Values.Add(request.AppointmentEndDate);

                qe.Criteria.Conditions.Add(ce2);

                if (!string.IsNullOrEmpty(RangeString))
                    RangeString += " | ";
                RangeString += string.Concat("EndRange: ", request.AppointmentEndDate.ToShortDateString());
            }

            if(!string.IsNullOrEmpty(request.FacilityIdentifier))
            {
                ConditionExpression ce3 = new ConditionExpression();
                ce3.AttributeName = "btsss_facilityidentifier";
                ce3.Operator = ConditionOperator.Like;
                ce3.Values.Add(request.FacilityIdentifier);

                qe.Criteria.Conditions.Add(ce3);

                if (!string.IsNullOrEmpty(RangeString))
                    RangeString += " | ";
                RangeString += string.Concat("Facility Identifier: ", request.FacilityIdentifier.ToString());
            }

            if (!string.IsNullOrEmpty(request.PatientIdentifier))
            {
                ConditionExpression ce3 = new ConditionExpression();
                ce3.AttributeName = "btsss_patientidentifier";
                ce3.Operator = ConditionOperator.Like;
                ce3.Values.Add(request.PatientIdentifier);

                qe.Criteria.Conditions.Add(ce3);

                if (!string.IsNullOrEmpty(RangeString))
                    RangeString += " | ";
                RangeString += string.Concat("Patient Identifier: ", request.PatientIdentifier.ToString());
            }

            var returnValue = _serviceProxy.RetrieveMultiple(qe);

            if (returnValue != null && returnValue.Entities.Count > 0)
            {
                foreach (Entity ent in returnValue.Entities)
                {
                    VeteranAppointment appt = MapGeneralAppointmentInfo(ent);

                    VetAppointments.Add(appt);
                }
            }

            if (VetAppointments.Count > 0)
            {
                if (RangeString != null)
                    response.DateRangeSearch = RangeString;
                if (VetAppointments != null)
                    response.Appointments = VetAppointments.ToArray();
                if (request.FacilityIdentifier != null)
                    response.FacilityIdentifier = request.FacilityIdentifier;
                if (request.PatientIdentifier != null)
                    response.PatientIdentifier = request.PatientIdentifier;

                response.ExceptionOccured = false;
                response.Message = "OK";
            }
            else
            {
                // this is not an error but needs a general message
                if (RangeString != null)
                    response.DateRangeSearch = RangeString;
                if (request.FacilityIdentifier != null)
                    response.FacilityIdentifier = request.FacilityIdentifier;
                if (request.PatientIdentifier != null)
                    response.PatientIdentifier = request.PatientIdentifier;

                response.Message = "No records returned";
                response.ExceptionOccured = false;
            }

            return response;
        }

        //public static List<VeteranAppointment> GetAppointmentsForDateRange(DateTime startDate, DateTime endDate)
        //{
        //    List<VeteranAppointment> Appointments = new List<VeteranAppointment>();
        //    // Go to CRM and Get the top level response object based on the request Patient ID
        //    QueryExpression qe = new QueryExpression("btsss_veteranappointmentdetail");
        //    qe.ColumnSet = new ColumnSet(true);
        //    qe.Criteria = new FilterExpression(LogicalOperator.And);

        //    ConditionExpression ce1 = new ConditionExpression();
        //    ce1.AttributeName = "btsss_appointmentdate";
        //    ce1.Operator = ConditionOperator.OnOrAfter;
        //    ce1.Values.Add(startDate);
        //    ConditionExpression ce2 = new ConditionExpression();
        //    ce2.AttributeName = "btsss_appointmentdate";
        //    ce2.Operator = ConditionOperator.OnOrBefore;
            //    ce2.Values.Add(endDate);

        //    qe.Criteria.Conditions.Add(ce1);
        //    qe.Criteria.Conditions.Add(ce2);
            
        //    var returnValue = _serviceProxy.RetrieveMultiple(qe);

        //    if (returnValue != null && returnValue.Entities.Count > 0)
        //    {
        //        foreach(Entity ent in returnValue.Entities)
        //        {
        //            VeteranAppointment appt = MapGeneralAppointmentInfo(ent);

        //            Appointments.Add(appt);
        //        }
        //    }

        //    return Appointments;
        //}

        public static VeteranAppointment MapGeneralAppointmentInfo(Entity ent)
        {
            VeteranAppointment response = new VeteranAppointment();
            if (ent.Attributes.Contains("btsss_patientidentifier") && ent.Attributes["btsss_patientidentifier"] != null)
                response.PatientIdentifier = ent.Attributes["btsss_patientidentifier"].ToString();
            if (ent.Attributes.Contains("btsss_appointmentdate") && ent.Attributes["btsss_appointmentdate"] != null)
                response.AppointmentDate = (DateTime)ent.Attributes["btsss_appointmentdate"];
            if (ent.Attributes.Contains("btsss_appointmentidentifier") && ent.Attributes["btsss_appointmentidentifier"] != null)
                response.AppointmentIdentifier = ent.Attributes["btsss_appointmentidentifier"].ToString();
            if (ent.Attributes.Contains("btsss_appointmentstatus") && ent.Attributes["btsss_appointmentstatus"] != null)
                response.AppointmentStatus = ent.Attributes["btsss_appointmentstatus"].ToString();
            if (ent.Attributes.Contains("btsss_exceptionoccured") && ent.Attributes["btsss_exceptionoccured"] != null)
                response.ExceptionOccured = (Boolean)ent.Attributes["btsss_exceptionoccured"];
            if (ent.Attributes.Contains("btsss_facilityidentifier") && ent.Attributes["btsss_facilityidentifier"] != null)
                response.FacilityIdentifier = ent.Attributes["btsss_facilityidentifier"].ToString();
            if (ent.Attributes.Contains("btsss_sopcode") && ent.Attributes["btsss_sopcode"] != null)
                response.SOPCode = ent.Attributes["btsss_sopcode"].ToString();
            if (ent.Attributes.Contains("btsss_message") && ent.Attributes["btsss_message"] != null)
                response.Message = ent.Attributes["btsss_message"].ToString();
            return response;
        }
    }
}