﻿using Microsoft.Xrm.Tooling.Connector;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections;
using System.Collections.Generic;
using VRM.Integration.Servicebus.Core;
using DataStub.Services;
using IMSDataStub.Services.Utilities;


namespace IMSDataStub.Services.MessageMaps
{
    public class GetVeteranAppointmentDetail
    {
        public static CrmServiceClient _serviceProxy { get; set; }
        public static Guid _userId { get; set; }

        public static VISTAVeteranAppointmentDetailResponse BuildMessageResponse(VISTAVeteranAppointmentDetailRequest request, CrmServiceClient crmSrv)
        {
            _serviceProxy = crmSrv;

            VISTAVeteranAppointmentDetailResponse response = new VISTAVeteranAppointmentDetailResponse();

            // Go to CRM and Get the top level response object based on the request Patient ID
            QueryExpression qe = new QueryExpression("btsss_veteranappointmentdetail");
            qe.ColumnSet = new ColumnSet(true);
            qe.Criteria = new FilterExpression().AddFilter(LogicalOperator.And);

            // Required
            if(!string.IsNullOrEmpty(request.AppointmentIdentifier))
            {
                ConditionExpression ce1 = new ConditionExpression();
                ce1.AttributeName = "btsss_appointmentidentifier";
                ce1.Operator = ConditionOperator.Like;
                ce1.Values.Add(request.AppointmentIdentifier.ToString());

                qe.Criteria.Conditions.Add(ce1);
            }

            // Optional
            if(!string.IsNullOrEmpty(request.FacilityIdentifier))
            {
                ConditionExpression ce2 = new ConditionExpression();
                ce2.AttributeName = "btsss_facilityidentifier";
                ce2.Operator = ConditionOperator.Like;
                ce2.Values.Add(request.FacilityIdentifier.ToString());

                qe.Criteria.Conditions.Add(ce2);
            }

            // Optional
            if (!string.IsNullOrEmpty(request.PatientIdentifier))
            {
                ConditionExpression ce3 = new ConditionExpression();
                ce3.AttributeName = "btsss_patientidentifier";
                ce3.Operator = ConditionOperator.Like;
                ce3.Values.Add(request.PatientIdentifier.ToString());

                qe.Criteria.Conditions.Add(ce3);
            }


            var returnValue = _serviceProxy.RetrieveMultiple(qe);

            if (returnValue != null && returnValue.Entities.Count == 1)
            {
                MapAppointmentInfo(ref response, returnValue.Entities[0]);
            }
            else
            {
                if(returnValue != null && returnValue.Entities != null)
                {
                    if (returnValue.Entities != null && returnValue.Entities.Count < 1)
                    {
                        // Set override message and error state for the return response if there is not some other error.
                        response.ExceptionOccured = false;
                        response.Message = "No Records Returned";
                    }
                    else
                    {
                        // Set override message and error state for the return response if there is not some other error.
                        response.ExceptionOccured = true;
                        response.Message = "Too many results returned. Resolve the duplicate record(s) or refine your search and try again";
                    }
                }
                else
                {
                    response.ExceptionOccured = true;
                    response.Message = "An exception occured retrieveing records from the source system.";
                }
            }
            if (request.PatientIdentifier != null)
                response.PatientIdentifier = request.PatientIdentifier;
            if (request.FacilityIdentifier != null)
                response.FacilityIdentifier = request.FacilityIdentifier;
            if (request.AppointmentIdentifier != null)
                response.AppointmentIdentifier = request.AppointmentIdentifier;

            return response;
        }

        public static void MapAppointmentInfo(ref VISTAVeteranAppointmentDetailResponse response, Entity ent)
        {
            if (ent.Attributes.Contains("btsss_patientidentifier") && ent.Attributes["btsss_patientidentifier"] != null)
                response.PatientIdentifier = ent.Attributes["btsss_patientidentifier"].ToString();
            if (ent.Attributes.Contains("btsss_appointmentidentifier") && ent.Attributes["btsss_appointmentidentifier"] != null)
                response.AppointmentIdentifier = ent.Attributes["btsss_appointmentidentifier"].ToString();
            if (ent.Attributes.Contains("btsss_facilityidentifier") && ent.Attributes["btsss_facilityidentifier"] != null)
                response.FacilityIdentifier = ent.Attributes["btsss_facilityidentifier"].ToString();
            if (ent.Attributes.Contains("btsss_appointmentdate") && ent.Attributes["btsss_appointmentdate"] != null)
                response.AppointmentDate = (DateTime)ent.Attributes["btsss_appointmentdate"];
            if (ent.Attributes.Contains("btsss_appointmentstatus") && ent.Attributes["btsss_appointmentstatus"] != null)
                response.AppointmentStatus = DataStubUtilities.getOptionSetString(((OptionSetValue)ent.Attributes["btsss_appointmentstatus"]).Value, "btsss_veteranappointmentdetail", "btsss_appointmentstatus", _serviceProxy);
            if (ent.Attributes.Contains("btsss_exceptionoccured") && ent.Attributes["btsss_exceptionoccured"] != null)
                response.ExceptionOccured = Convert.ToBoolean(ent.Attributes["btsss_exceptionoccured"].ToString());
            if (ent.Attributes.Contains("btsss_facilityidentifier") && ent.Attributes["btsss_facilityidentifier"] != null)
                response.FacilityIdentifier = ent.Attributes["btsss_facilityidentifier"].ToString();
            if (ent.Attributes.Contains("btsss_sopcode") && ent.Attributes["btsss_sopcode"] != null)
                response.SOPCode = ent.Attributes["btsss_sopcode"].ToString();
            if (ent.Attributes.Contains("btsss_message") && ent.Attributes["btsss_message"] != null)
                response.Message = ent.Attributes["btsss_message"].ToString();
            if(ent.Attributes.Contains("btsss_isinnetwork"))
                response.IsInNetwork = Convert.ToBoolean(ent.Attributes["btsss_isinnetwork"].ToString());
        }
    }
}