﻿using Microsoft.Xrm.Tooling.Connector;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections;
using System.Collections.Generic;
using VRM.Integration.Servicebus.Core;
using DataStub.Services;

namespace IMSDataStub.Services.MessageMaps
{
    public static class FMSBankingMessageMap
    {
        public static CrmServiceClient _serviceProxy { get; set; }
        public static Guid _userId { get; set; }

        public static VeteranBankInformationResponse BuildMessageResponse(VeteranBankInformationRequest request, CrmServiceClient crmSrv)
        {
            _serviceProxy = crmSrv;

            VeteranBankInformationResponse response = new VeteranBankInformationResponse();

            response.OrganizationName = request.OrganizationName;
            response.OrganizationName = request.PatientIdentifier;

            // Go to CRM and Get the top level response object based on the request Patient ID
            QueryByAttribute qba = new QueryByAttribute("btsss_veteranbankinformationrequest");
            qba.ColumnSet = new ColumnSet(true);
            qba.Attributes.AddRange("btsss_patientidentifier");
            qba.Values.AddRange(request.PatientIdentifier);
            var returnValue = _serviceProxy.RetrieveMultiple(qba);

            if (returnValue != null && returnValue.Entities.Count == 1)
            {
                Entity ent = returnValue.Entities[0];

                if (ent.Attributes["btsss_patientidentifier"].Equals(request.PatientIdentifier) == true)
                {
                    // Get the response data
                    Entity retrieveBankInfo = _serviceProxy.Retrieve("btsss_veteranbankinformationresponse", ((EntityReference)ent.Attributes["btsss_veteranbankinformationresponse"]).Id, new ColumnSet(true));

                    if( retrieveBankInfo == null)
                    {
                        response.Message = "No FMS Bank Record information found for Veteran";
                        response.ExceptionOccured = true;
                        return response;
                    }

                    response = MapVeteranBankInformation(retrieveBankInfo);

                    response.Message = "FMS Record returned OK";
                    response.ExceptionOccured = false;
                    return response;
                }
                else
                {
                    response.Message = returnValue.Entities.Count.ToString() + " - Veteran Bank Information Records were returned. None of them met the identifier type criteria";
                }
            }
            else
            {
                // There were not any person records that meet the passed in informtion
                response.ExceptionOccured = false;
                response.OrganizationName = request.OrganizationName;
                response.Message = returnValue.Entities.Count.ToString() + " - Veteran Bank Information Records were returned.";

            }
            return response;
        }

        public static VeteranBankInformationResponse MapVeteranBankInformation(Entity ent)
        {
            VeteranBankInformationResponse response = new VeteranBankInformationResponse();
            if(ent.Attributes.Contains("btsss_patientidentifier") && ent.Attributes["btsss_patientidentifier"] != null)
                response.PatientIdentifier = ent.Attributes["btsss_patientidentifier"].ToString();
            if (ent.Attributes.Contains("btsss_bankroutingnumber") && ent.Attributes["btsss_bankroutingnumber"] != null)
                response.BankRoutingNumber = ent.Attributes["btsss_bankroutingnumber"].ToString();
            if (ent.Attributes.Contains("btsss_bankaccountnumber") && ent.Attributes["btsss_bankaccountnumber"] != null)
                response.BankAccountNumber = ent.Attributes["btsss_bankaccountnumber"].ToString();
            if (ent.Attributes.Contains("btsss_bankaccounttype") && ent.Attributes["btsss_bankaccounttype"] != null)
                response.BankAccountType = Utilities.DataStubUtilities.getOptionSetString(((OptionSetValue)ent.Attributes["btsss_bankaccounttype"]).Value, "btsss_veteranbankinformationresponse", "btsss_bankaccounttype", _serviceProxy);
            if (ent.Attributes.Contains("btsss_message") && ent.Attributes["btsss_message"] != null)
                response.Message = ent.Attributes["btsss_message"].ToString();
            if (ent.Attributes.Contains("btsss_exceptionoccured") && ent.Attributes["btsss_exceptionoccured"] != null)
                response.ExceptionOccured = Convert.ToBoolean(ent.Attributes["btsss_exceptionoccured"].ToString());
            if (ent.Attributes.Contains("btsss_organizationname") && ent.Attributes["btsss_organizationname"] != null)
                response.OrganizationName = ent.Attributes["btsss_organizationname"].ToString();
            return response;
        }
    }
}