﻿using System.ServiceModel;
using System.Runtime.Serialization;
using System;
using VRM.Integration.Servicebus.Core;
using IMSDataStub.Services.EnrollmentServiceWSDL;
using System.Linq;

namespace DataStub.Services
{
    [ServiceContract]
    public interface IDataStubService
    {
        // MVI specific Data Stubbs
        [OperationContract]
        RetrieveOrSearchPersonResponse getRetrieveOrSearchPersonResponseStubData(RetrieveWithOrchestrationRequest request);

        // Net Income specific Data Stubs
        [OperationContract]
        VeteranNetIncomeResponse getVeteranNetIncomeInformation(VeteranNetIncomeRequest request);

        // FMS information specific data stubs
        [OperationContract]
        VeteranBankInformationResponse getVeteranBankInformation(VeteranBankInformationRequest request);

        // Appointment Information using a date range
        [OperationContract]
        VISTAVeteranAppointmentDateRangeResponse getVISTAVeteranAppointmentsByDateRange(VISTAVeteranAppointmentDateRangeRequest request);

        // Appointment Information for specific Appointment Identifier (Required)/Facility Identifier (Optional)/ Patient Identifier (Optional)
        [OperationContract]
        VISTAVeteranAppointmentDetailResponse getVISTAVeteranAppointmentByAppointmentIdentifier(VISTAVeteranAppointmentDetailRequest request);

        [OperationContract]
        getEESummaryHistoryResponse getEESummaryHistory(getEESummaryHistoryRequest request);

        [OperationContract]
        getDeliveryPreferenceResponse getDeliveryPrefernceResponse(getDeliveryPreferenceRequest request);
    }

    [DataContract]
    public class VISTAVeteranAppointmentDateRangeRequest
    {
        [DataMember]
        public Guid MessageId { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public DateTime AppointmentStartDate { get; set; }

        [DataMember]
        public DateTime AppointmentEndDate { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public string UserFirstName { get; set; }

        [DataMember]
        public Guid UserId { get; set; }

        [DataMember]
        public string UserLastName { get; set; }
    }

    [DataContract]
    public class VISTAVeteranAppointmentDateRangeResponse
    {
        [DataMember]
        public string DateRangeSearch { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public VeteranAppointment [] Appointments { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

    }

    [DataContract]
    public class VeteranAppointment
    {
        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public DateTime AppointmentDate { get; set; }

        [DataMember]
        public string AppointmentStatus { get; set; }

        [DataMember]
        public string SOPCode { get; set; }

        [DataMember]
        public string AppointmentIdentifier { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }
    }

    [DataContract]
    public class VISTAVeteranAppointmentDetailRequest
    {
        [DataMember]
        public Guid MessageId { get; set; }

        [DataMember]
        public string AppointmentIdentifier { get; set; }

        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public string UserFirstName { get; set; }

        [DataMember]
        public Guid UserId { get; set; }

        [DataMember]
        public string UserLastName { get; set; }
    }

    [DataContract]
    public class VISTAVeteranAppointmentDetailResponse
    {
        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public string AppointmentIdentifier { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public DateTime AppointmentDate { get; set; }

        [DataMember]
        public string AppointmentStatus { get; set; }

        [DataMember]
        public string SOPCode { get; set; }

        [DataMember]
        public Boolean IsInNetwork { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }
    }

    [DataContract]
    public class RetrieveWithOrchestrationRequest
    {
        //private enum _IdentifierType
        //{
        //    EmployeeIdentifier,
        //    NationalIdentifier,
        //    ParticipantNumber,
        //    PatientIdentifier,
        //    SocialSecurityNumber,
        //    Unspecified
        //}

        [DataMember]
        public string AssigningAuthority { get; set; }

        [DataMember]
        public string AssigningFacility { get; set; }

        [DataMember]
        public MessageProcessType FetchMessageProcessType { get; set; }

        [DataMember]
        public string IdentifierType { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string UserFirstName { get; set; }

        [DataMember]
        public Guid UserId { get; set; }

        [DataMember]
        public string UserLastName { get; set; }
    }

    [DataContract]
    public class VeteranNetIncomeRequest
    {
        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string EdiPi { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public string UserFirstName { get; set; }

        [DataMember]
        public string UserLastName { get; set; }

        [DataMember]
        public Guid UserId { get; set; }
    }

    [DataContract]
    public class VeteranBankInformationRequest
    {
        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string EdiPi { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public string UserFirstName { get; set; }

        [DataMember]
        public string UserLastName { get; set; }

        [DataMember]
        public Guid UserId { get; set; }
    }

    [DataContract]
    public class RetrieveOrSearchPersonResponse
    {
        [DataMember]
        public Acknowledgement Acknowledgement { get; set; }

        [DataMember]
        public bool ExceptionOccured { get; set; }

        [DataMember]
        public MessageProcessType FetchMessageProcessType { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public PatientPerson [] Person { get; set; }

        [DataMember]
        public QueryAcknowledgement QueryAcknowledgement { get; set; }

        [DataMember]
        public string RawMviExceptionMessage { get; set; }
    }

    [DataContract]
    public class VeteranNetIncomeResponse
    {
        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string EdiPi { get; set; }

        [DataMember]
        public DateTime IncomeExpiration { get; set; }

        [DataMember]
        public Guid IncomeModifiedBy { get; set; }

        [DataMember]
        public DateTime IncomeModifiedOn { get; set; }

        [DataMember]
        public string IncomeSource { get; set; }

        [DataMember]
        public string NetIncome { get; set; }

        [DataMember]
        public string OldNetIncome { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }
    }

    [DataContract]
    public class VeteranBankInformationResponse
    {
        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string BankRoutingNumber { get; set; }

        [DataMember]
        public string BankAccountNumber { get; set; }

        [DataMember]
        public string BankAccountType { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }
    }

    // Supporting Data contracts
    [DataContract]
    public class PatientPerson
    {
        [DataMember]
        public PatientAddress Address { get; set; }
        [DataMember]
        public string BirthDate { get; set; }

        [DataMember]
        public UnattendedSearchRequest [] CorrespondingIdList { get; set; }

        [DataMember]
        public string DeceasedDate { get; set; }

        [DataMember]
        public string EdiPi { get; set; }

        [DataMember]
        public string FullAddress { get; set; }

        [DataMember]
        public string GenderCode { get; set; }

        [DataMember]
        public string Identifier { get; set; }

        [DataMember]
        public string IdentifierType { get; set; }

        [DataMember]
        public string IdentifyTheft { get; set; }

        [DataMember]
        public Boolean IsDeceased { get; set; }

        [DataMember]
        public Name [] NameList { get; set; }

        [DataMember]
        public string FullName { get; set; }

        [DataMember]
        public string ParticipantId { get; set; }

        [DataMember]
        public string PhoneNumber { get; set; }

        [DataMember]
        public string RecordSource { get; set; }

        [DataMember]
        public string SocialSecurityNumber { get; set; }

        [DataMember]
        public string StatusCode { get; set; }

        [DataMember]
        public string Url { get; set; }
    }

    [DataContract]
    public class Name
    {
        public enum NameUse
        {
            Alias,
            Assigned,
            Certificate,
            Indigenous,
            Legal,
            Maiden,
            OfficialRegistry,
            Pseudoymn,
            Religous,
            Unspecified
        }
        [DataMember]
        public string FamilyName { get; set; }

        [DataMember]
        public string GivenName { get; set; }

        [DataMember]
        public string MiddleName { get; set; }

        [DataMember]
        public string NamePrefix { get; set; }

        [DataMember]
        public string NameSuffix { get; set; }

        [DataMember]
        public string NameType { get; set; }

        [DataMember]
        public NameUse Use { get; set; }
    }

    [DataContract]
    public class UnattendedSearchRequest
    {
        [DataMember]
        public string AssigningAuthority { get; set; }

        [DataMember]
        public string AssigningFacility { get; set; }

        [DataMember]
        public string AuthorityOid { get; set; }

        [DataMember]
        public MessageProcessType FetchMessageProcessType { get; set; }

        [DataMember]
        public string IdentifierType { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string RawValueFromMvi { get; set; }

        [DataMember]
        public string UseRawMviValue { get; set; }

        [DataMember]
        public string UserFirstName { get; set; }

        [DataMember]
        public Guid UserId { get; set; }

        [DataMember]
        public string UserLastName { get; set; }
    }

    [DataContract]
    public class PatientAddress
    {
        public enum AddressUse
        {
            Bad,
            Confidential,
            Home,
            Other,
            OtherHome,
            PrimaryHome,
            Temporary,
            Unspecified,
            Workplace
        }
        [DataMember]
        public string City { get; set; }

        [DataMember]
        public string Country { get; set; }

        [DataMember]
        public string PostalCode { get; set; }

        [DataMember]
        public string State { get; set; }

        [DataMember]
        public string StreetAddressLine { get; set; }

        [DataMember]
        public AddressUse Use { get; set; }
    }

    [DataContract]
    public class Acknowledgement
    {
        [DataMember]
        public AcknowledgementDetail [] AcknowledgementDetails { get; set; }

        [DataMember]
        public string TargetMessage { get; set; }

        [DataMember]
        public string TypeCode { get; set; }
    }
    public class AcknowledgementDetail
    {
        [DataMember]
        public AcknowledgementDetailCode Code { get; set; }

        [DataMember]
        public string Text { get; set; }
    }

    public class AcknowledgementDetailCode
    {
        [DataMember]
        public string Code { get; set; }

        [DataMember]
        public string CodeSystemName { get; set; }

        [DataMember]
        public string DisplayName { get; set; }
    }

    [DataContract]
    public class QueryAcknowledgement
    {
        [DataMember]
        public string QueryResponseCode { get; set; }

        [DataMember]
        public string ResultCurrentQuantity { get; set; }
    }
}
