﻿using System;
using Microsoft.Xrm.Tooling.Connector;
using System.ServiceModel;
using DataStub.Services.MessageMaps;
using IMSDataStub.Services.MessageMaps;
using System.Configuration;
using IMSDataStub.Services.EnrollmentServiceWSDL;

namespace DataStub.Services
{
    [ServiceBehavior(InstanceContextMode = InstanceContextMode.PerCall)]
    public class DataStubService : IDataStubService, IDisposable
    {
        public void Dispose()
        {
            crmSrv = null;
        }

        private string connString
        {
            get
            {
                return ConfigurationManager.AppSettings["IMSConnectString"];
            }
        }        
        private CrmServiceClient crmSrv { get; set; }
        public RetrieveOrSearchPersonResponse getRetrieveOrSearchPersonResponseStubData(RetrieveWithOrchestrationRequest request)
        {
            try
            {
                RetrieveOrSearchPersonResponse response = new RetrieveOrSearchPersonResponse();

                if (request.PatientIdentifier != null && request.IdentifierType != null)
                {
                    crmSrv = new CrmServiceClient(connString);

                    if (crmSrv != null)
                    {
                        response = MVIPersonSearchMessageMap.BuildMessageResponse(request, crmSrv);
                    }
                    else
                    {
                        response.Message = "Failed to get a CrmServiceClient handle to the CRM Instance.";
                        response.ExceptionOccured = true;
                    }
                }
                else
                {
                    response.ExceptionOccured = true;
                    response.RawMviExceptionMessage = "Unable to process request: Incorrect request parameters passed in.";
                }

                return response;

            }
            catch (Exception ex)
            {
                throw new Exception("A Critical Error Occured in getRetrieveOrSearchPersonResponseStubData " + ex.InnerException.ToString() + ex.Message.ToString());
            }
        }

        public VeteranBankInformationResponse getVeteranBankInformation(VeteranBankInformationRequest request)
        {
            try
            {
                VeteranBankInformationResponse response = new VeteranBankInformationResponse();
                crmSrv = new CrmServiceClient(connString);

                if (crmSrv != null)
                {
                    response = FMSBankingMessageMap.BuildMessageResponse(request, crmSrv);
                }
                else
                {
                    response.Message = "Failed to get a CrmServiceClient handle to the CRM Instance.";
                    response.ExceptionOccured = true;
                }

                return response;
            }
            catch (Exception ex)
            {
                throw new Exception("A Critical Error Occured in getVeteranBankInformation " + ex.InnerException.ToString() + ex.Message.ToString());
            }
        }

        public VeteranNetIncomeResponse getVeteranNetIncomeInformation(VeteranNetIncomeRequest request)
        {
            try
            {
                VeteranNetIncomeResponse response = new VeteranNetIncomeResponse();
                crmSrv = new CrmServiceClient(connString);

                if (crmSrv != null)
                {
                    response = getVeteranNetIncome.BuildMessageResponse(request, crmSrv);
                }
                else
                {
                    response.Message = "Failed to get a CrmServiceClient handle to the CRM Instance.";
                    response.ExceptionOccured = true;
                }

                return response;
            }
            catch (Exception ex)
            {
                throw new Exception("A Critical Error Occured in getVeteranNetIncomeInformation " + ex.InnerException.ToString() + ex.Message.ToString());
            }
        }

        public VISTAVeteranAppointmentDateRangeResponse getVISTAVeteranAppointmentsByDateRange(VISTAVeteranAppointmentDateRangeRequest request)
        {
            try
            {
                VISTAVeteranAppointmentDateRangeResponse response = new VISTAVeteranAppointmentDateRangeResponse();
                crmSrv = new CrmServiceClient(connString);

                if (crmSrv != null)
                {
                    response = GetVeteranAppointmentDateRange.BuildMessageResponse(request, crmSrv);
                }
                else
                {
                    response.Message = "Failed to get a CrmServiceClient handle to the CRM Instance.";
                    response.ExceptionOccured = true;
                }

                return response;
            }
            catch (Exception ex)
            {
                throw new Exception("A Critical Error Occured in GetVeteranAppointmentRange " + ex.InnerException.ToString() + ex.Message.ToString());
            }
        }

        public VISTAVeteranAppointmentDetailResponse getVISTAVeteranAppointmentByAppointmentIdentifier(VISTAVeteranAppointmentDetailRequest request)
        {
            try
            {
                VISTAVeteranAppointmentDetailResponse response = new VISTAVeteranAppointmentDetailResponse();
                crmSrv = new CrmServiceClient(connString);

                if (crmSrv != null)
                {
                    response = GetVeteranAppointmentDetail.BuildMessageResponse(request, crmSrv);
                }
                else
                {
                    response.Message = "Failed to get a CrmServiceClient handle to the CRM Instance.";
                    response.ExceptionOccured = true;
                }

                return response;
            }
            catch (Exception ex)
            {
                throw new Exception("A Critical Error Occured in GetVeteranAppointmentDetail " + ex.InnerException.ToString() + ex.Message.ToString());
            }
        }

        public getEESummaryHistoryResponse getEESummaryHistory(getEESummaryHistoryRequest request)
        {
            try
            {
                getEESummaryHistoryResponse response = new getEESummaryHistoryResponse();
                crmSrv = new CrmServiceClient(connString);

                if (crmSrv != null)
                {
                    response = IMSgetEESummaryHistory.BuildMessageResponse(request, crmSrv);
                }
                else
                {
                    response.noDataMessage = "Failed to get a CrmServiceClient handle to the CRM Instance.";
                    response.eesVersion = "v1.0";
                }

                return response;
            }
            catch (Exception ex)
            {
                throw new Exception("A Critical Error Occured in GetVeteranAppointmentDetail " + ex.InnerException.ToString() + ex.Message.ToString());
            }
        }

        public getDeliveryPreferenceResponse getDeliveryPrefernceResponse(getDeliveryPreferenceRequest request)
        {
            return new getDeliveryPreferenceResponse();
        }
    }
}
