﻿using System;
using VIMT.Integrations.VeteranProfile.Messages;
using VIMT.Integrations.FMS.Messages;
using VIMT.Integrations.NetIncome.Messages;
using VIMT.Integrations.MVI.Messages;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;

namespace VIMT.Integrations.VeteranProfile.WebService.Processors
{
    public class VeteranProfileProcessor
    {
        public LoadVeteranProfileResponse Execute(LoadVeteranProfileRequest request)
        {
            try
            {
                LoadVeteranProfileResponse response = new LoadVeteranProfileResponse();
                //Invoke the processor here..and fill up the response object

                //**************************************************************************************************
                // Handle MVI Data Gathering
                //**************************************************************************************************
                // TODO: Need to wire in the Correct error handling for MVI in order to pass MVI testing.
                // TODO: create mapping methods that can be reused when the cut over to non stubbed data takes place 
                MVI.Messages.RetrieveWithOrchestrationRequest mviRequest = new MVI.Messages.RetrieveWithOrchestrationRequest();
                mviRequest.PatientIdentifier = request.VeteranIdentifier;
                mviRequest.OrganizationName = request.OrganizationName;
                mviRequest.IdentifierType = request.VeteranIdentifierType;
                mviRequest.AssigningAuthority = request.AssigningAuthority;
                mviRequest.AssigningFacility = request.AssigningFacility;
                mviRequest.FetchMessageProcessType = MessageProcessType.Local;
                mviRequest.UserFirstName = request.UserFirstName;
                mviRequest.UserLastName = request.UserLastName;
                mviRequest.UserId = request.UserId;

                var mviException = GetMVIData(ref response, mviRequest);

                //**************************************************************************************************
                // Build FMS Bank Information Requiest
                //**************************************************************************************************
                LoadBankInformationRequest bankRequest = new LoadBankInformationRequest();
                bankRequest.EdiPi = request.VeteranIdentifier;
                bankRequest.OrganizationName = request.OrganizationName;
                bankRequest.PatientIdentifier = request.VeteranIdentifier;
                bankRequest.UserFirstName = request.UserFirstName;
                bankRequest.UserId = request.UserId;
                bankRequest.UserLastName = request.UserLastName;

                var bankException = GetBankInformationData(ref response, bankRequest);
                //**************************************************************************************************
                // Build Net Income Information Request
                //**************************************************************************************************
                LoadNetIncomeRequest incomeRequest = new LoadNetIncomeRequest();
                incomeRequest.EdiPi = request.VeteranIdentifier;
                incomeRequest.PatientIdentifier = request.VeteranIdentifier;
                incomeRequest.OrganizationName = request.OrganizationName;
                incomeRequest.UserFirstName = request.UserFirstName;
                incomeRequest.UserId = request.UserId;
                incomeRequest.UserLastName = request.UserLastName;

                var incomeException = GetIncomeData(ref response, incomeRequest);

                return response;
            }
            catch (NetworkOperationCancelledException ex)
            {
                if (ex.InnerException.ToString().Contains("There was no endpoint listening"))
                {
                    throw new InvalidOperationException(ex.InnerException.ToString());
                }
                else
                {
                    throw new NetworkOperationCancelledException(ex.Message);
                }

            }
            catch (Exception ex)
            {
                if (ex.InnerException != null)
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "VeteranProfileProcessor, Execute", "Exception:" + ex.Message + ex.InnerException.ToString());
                }
                else
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "VeteranProfileProcessor, Execute", "Exception:" + ex.Message + "No Inner Exception Text");
                }

                if (ex.Message.Contains("No Endpoint Listening"))
                {
                    throw new NetworkOperationCancelledException(ex.InnerException.ToString());
                }
                else
                {
                    throw new InvalidOperationException(ex.Message.ToString());
                }
            }
        }

        #region MVI Integration
        private Boolean GetMVIData(ref LoadVeteranProfileResponse response, RetrieveWithOrchestrationRequest mviRequest)
        {
            //var proxy = ServiceFactory.GetAppealServiceReference(new HeaderInfo());
            //var bankResponse = proxy.getVeteranBankInformationInformation(bankRequest);

            var mviResponse = mviRequest.SendReceive<RetrieveOrSearchPersonResponse>(MessageProcessType.Local);

            if (mviResponse != null)
            {
                // Map the data to a response object
                mviMapResponse(ref response, mviResponse);
            }

            if (response.MviExceptionOccurred)
            {
                return false;
            }
            else
            {
                return true;
            }
        }


        private void mviMapResponse(ref LoadVeteranProfileResponse response, RetrieveOrSearchPersonResponse mviResponse)
        {
            if (mviResponse.Message != null)
            {
                if (mviResponse.Person != null && mviResponse.Person.Length == 1)
                {
                    response.IsVeteran = true;
                    response.IsCaretaker = false;

                    int i = 0;
                    int n = 0;
                    if (mviResponse.Person[i].NameList != null && mviResponse.Person[i].NameList[n] != null)
                    {
                        if (mviResponse.Person[i].NameList[n].NamePrefix != null)
                            response.NamePrefix = mviResponse.Person[i].NameList[n].NamePrefix.ToString();
                        if (mviResponse.Person[i].NameList[n].GivenName != null)
                            response.FirstName = mviResponse.Person[i].NameList[n].GivenName.ToString();
                        if (mviResponse.Person[i].NameList[n].FamilyName != null)
                            response.LastName = mviResponse.Person[i].NameList[n].FamilyName.ToString();
                        if (mviResponse.Person[i].NameList[n].NameSuffix != null)
                            response.NameSuffix = mviResponse.Person[i].NameList[n].NameSuffix.ToString();
                    }

                    if (mviResponse.Person[i].SocialSecurityNumber != null)
                        response.MaskedSocial = mviResponse.Person[i].SocialSecurityNumber.ToString();
                    if (mviResponse.Person[i].FullName != null)
                        response.FullName = mviResponse.Person[i].FullName.ToString();
                    if (mviResponse.Person[i].BirthDate != null)
                        response.DateOfBirth = DateTime.Parse(mviResponse.Person[i].BirthDate.ToString());

                    response.MviExceptionOccurred = mviResponse.ExceptionOccured;
                    if (response.MviExceptionOccurred == true)
                    {
                        response.RawMviReturnMessage = mviResponse.Message;
                    }
                    else
                    {
                        response.RawMviReturnMessage = string.Empty;
                    }
                }
                else
                {
                    response.IsVeteran = false;
                    response.IsCaretaker = true;
                    response.Message = "MVI Returned no Data";
                    response.RawMviReturnMessage = "No Veteran Records were returned for the requested information.";
                }
            }
        }

        #endregion MVI Integration

        #region FMS Bank Integration
        private Boolean GetBankInformationData(ref LoadVeteranProfileResponse response, LoadBankInformationRequest bankRequest)
        {
            //var proxy = ServiceFactory.GetAppealServiceReference(new HeaderInfo());
            //var bankResponse = proxy.getVeteranBankInformationInformation(bankRequest);

            var bankResponse = bankRequest.SendReceive<LoadBankInformationResponse>(MessageProcessType.Local);

            if (bankResponse != null)
            {
                // Map the data to a response object
                bankMapResponse(ref response, bankResponse);
            }

            if (response.BankExceptionOccured)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        // TODO: this is bypasing the actual VIMT call for FMS Bank Information.
        private void bankMapResponse(ref LoadVeteranProfileResponse response, LoadBankInformationResponse bankResponse)
        {
            if (bankResponse.BankAccountNumber != null)
                response.MaskedBankAccountNumber = bankResponse.BankAccountNumber;
            if (bankResponse.BankRoutingNumber != null)
                response.BankAccountRoutingNumber = bankResponse.BankRoutingNumber;
            if (bankResponse.BankAccountType != null)
                response.BankAccountType = bankResponse.BankAccountType;
        }
        #endregion FMS Bank Integration

        #region Veteran Income Integration

        private Boolean GetIncomeData(ref LoadVeteranProfileResponse response, LoadNetIncomeRequest incomeRequest)
        {
            var incomeResponse = incomeRequest.SendReceive<LoadNetIncomeResponse>(MessageProcessType.Local);

            if (incomeResponse != null)
            {
                // Map the data to a response object
                IncomeMapResponse(ref response, incomeResponse);
            }


            if (response.NetIncomeExceptionOccured)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        private void IncomeMapResponse(ref LoadVeteranProfileResponse response, LoadNetIncomeResponse incomeResponse)
        {
            response.NetIncome = incomeResponse.NetIncome;
            response.IncomeExpiration = incomeResponse.IncomeExpiration;
            response.IncomeModifiedBy = incomeResponse.IncomeModifiedBy;
            response.IncomeModifiedOn = incomeResponse.IncomeModifiedOn;
            response.IncomeSource = incomeResponse.IncomeSource;
            response.OldNetIncome = incomeResponse.OldNetIncome;
            response.NetIncomeExceptionOccured = incomeResponse.ExceptionOccured;
            response.NetIncomeExceptionMessage = incomeResponse.Message;
        }
        #endregion Veteran Income Integration
    }
}
