﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIMT.Integrations.VeteranProfile.Messages;
using VIMT.Integrations.VeteranProfile.WebService.Processors;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.VeteranProfile.WebService.Handlers
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.LoadVeteranProfileRequest)]
    public class IntegrationsVeteranProfileHandler : RequestResponseHandler
    {
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                var VeteranProfileMessage = message as LoadVeteranProfileRequest;
                if (VeteranProfileMessage != null)
                {
                    //LogMessageReceipt(VeteranProfileMessage);
                    return new VeteranProfileProcessor().Execute(VeteranProfileMessage);
                }
                return null;
            }
            catch (Exception ex)
            {
                //Log exception and rethrow
                Logger.Instance.Error("Exception from IntegrationsVeteranProfileHandler", ex);
                throw;
            }
        }
    }
}
