﻿using Microsoft.Xrm.Sdk;
using System;
using VIMT.Integrations.VeteranProfile.Service.Configuration;
using VIMT.Integrations.VeteranProfile.Service.DataStubServiceReference;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.VeteranProfile.Service.Wcf
{
    public class ServiceFactory
    {
        // Uses IMS Endopint to point to the service this example uses parameters passed in
        public static IDataStubService GetAppealServiceReference(IOrganizationService organizationService, Guid userId)
        {
            var channel = new ServiceCustomClientChannel<IDataStubService>("BasicHttpBinding_IDataStubService", ConfigurationLocation.GetConfigFilePath("EC"));

            channel.Endpoint.AddSecurityHeader(organizationService, userId);

            SoapLog.Current.Active = VeteranProfileConfiguration.Current.EnableLogging;

            return channel.CreateChannel();
        }

        // Uses IMS Endopint to point to the service this example uses Header Information
        public static IDataStubService GetAppealServiceReference(HeaderInfo headerInfo)
        {
            var channel = new ServiceCustomClientChannel<IDataStubService>("BasicHttpBinding_IDataStubService", ConfigurationLocation.GetConfigFilePath("EC"));

            //channel.Endpoint.AddSecurityHeader(headerInfo);

            //SoapLog.Current.Active = VeteranProfileConfiguration.Current.EnableLogging;

            return channel.CreateChannel();
        }

        // Uses IMS Endopint to point to the service this example does not use a header
        public static IDataStubService GetAppealServiceReference()
        {
            var channel = new ServiceCustomClientChannel<IDataStubService>("BasicHttpBinding_IDataStubService", ConfigurationLocation.GetConfigFilePath("EC"));

            return channel.CreateChannel();
        }
    }
}
