﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.VeteranProfile.Messages
{
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.LoadVeteranProfileRequest)]
    [DataContract]
    public class LoadVeteranProfileRequest : MessageBase
    {
        [DataMember]
        public string UserFirstName { get; set; }
        [DataMember]
        public string UserLastName { get; set; }
        [DataMember]
        public string OrganizationName { get; set; }
        [DataMember]
        public Guid UserId { get; set; }
        [DataMember]
        public string VeteranIdentifier { get; set; }
        [DataMember]
        public string VeteranIdentifierType { get; set; }
        [DataMember]
        public string AssigningAuthority { get; set; }
        [DataMember]
        public string AssigningFacility { get; set; }
    }

    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.LoadVeteranProfileResponse)]
    [DataContract]
    public class LoadVeteranProfileResponse : MessageBase
    {
        [DataMember]
        public string NameSuffix { get; set; }
        [DataMember]
        public string NamePrefix { get; set; }
        [DataMember]
        public string FullName { get; set; }
        [DataMember]
        public string FirstName { get; set; }
        [DataMember]
        public string MiddleName { get; set; }
        [DataMember]
        public string LastName { get; set; }
        [DataMember]
        public string MaskedSocial { get; set; }
        [DataMember]
        public string PhoneNumber { get; set; }
        [DataMember]
        public DateTime DateOfBirth { get; set; }
        [DataMember]
        public Boolean IsDeceased { get; set; }
        [DataMember]
        public DateTime DeceasedDate { get; set; }
        [DataMember]
        public Address PrimaryAddress { get; set; }
        [DataMember]
        public Address TemporaryAddress { get; set; }
        [DataMember]
        public bool IsCaretaker { get; set; }
        [DataMember]
        public bool IsVeteran { get; set; }
        [DataMember]
        public string GenderCode { get; set; }
        [DataMember]
        public string RecordSource { get; set; }
        [DataMember]
        public string MaskedBankAccountNumber { get; set; }
        [DataMember]
        public string BankAccountRoutingNumber { get; set; }
        [DataMember]
        public string BankAccountType { get; set; }
        [DataMember]
        public string NetIncome { get; set; }
        [DataMember]
        public DateTime IncomeExpiration { get; set; }
        [DataMember]
        public Guid IncomeModifiedBy { get; set; }
        [DataMember]
        public DateTime IncomeModifiedOn { get; set; }
        [DataMember]
        public string IncomeSource { get; set; }
        [DataMember]
        public string OldNetIncome { get; set; }
        [DataMember]
        public string StatusCode { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public Boolean MviExceptionOccurred { get; set; }
        [DataMember]
        public string RawMviReturnMessage { get; set; }
        [DataMember]
        public Boolean BankExceptionOccured { get; set; }
        [DataMember]
        public string BankExceptionMessage { get; set; }
        [DataMember]
        public Boolean NetIncomeExceptionOccured { get; set; }
        [DataMember]
        public string NetIncomeExceptionMessage { get; set; }
    }

    [DataContract]
    public class Address
    {
        public enum AddressType
        {
            Bad,
            Confidential,
            Home,
            Other,
            OtherHome,
            PrimaryHome,
            Temporary,
            Unspecified,
            Workplace
        }

        [DataMember]
        public string Line1 { get; set; }
        [DataMember]
        public string Line2 { get; set; }
        [DataMember]
        public string City { get; set; }
        [DataMember]
        public string State { get; set; }
        [DataMember]
        public string Zip { get; set; }
        [DataMember]
        public string Lat { get; set; }
        [DataMember]
        public string Long { get; set; }
        [DataMember]
        public string Country { get; set; }
        [DataMember]
        public AddressType Use { get; set; }
    }

}
