﻿using System;
using System.Collections.Generic;
using VIMT.Integrations.Appointments.Messages;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;


namespace VIMT.Integrations.Appointments.WebService.Processors
{
    public class VISTAAppointmentsDateRangeProcessor
    {
        public LoadVISTAAppointmentsDateRangeResponse Execute(LoadVISTAAppointmentsDateRangeRequest request)
        {
            try
            {
                LoadVISTAAppointmentsDateRangeResponse response = new LoadVISTAAppointmentsDateRangeResponse();

                Service.DataStubServiceReference.VISTAVeteranAppointmentDateRangeRequest serviceRequest = new Service.DataStubServiceReference.VISTAVeteranAppointmentDateRangeRequest();

                if(!string.IsNullOrEmpty(request.AppointmentStartDate))
                    serviceRequest.AppointmentStartDate = DateTime.Parse(request.AppointmentStartDate);
                if (!string.IsNullOrEmpty(request.AppointmentEndDate))
                    serviceRequest.AppointmentEndDate = DateTime.Parse(request.AppointmentEndDate);
                if (!string.IsNullOrEmpty(request.PatientIdentifier))
                    serviceRequest.PatientIdentifier = request.PatientIdentifier;
                if (!string.IsNullOrEmpty(request.OrganizationName))
                    serviceRequest.OrganizationName = request.OrganizationName;
                if (!string.IsNullOrEmpty(request.UserFirstName))
                    serviceRequest.UserFirstName = request.UserFirstName;
                if (request.UserId != null && request.UserId.ToString() != Guid.Empty.ToString())
                    serviceRequest.UserId = request.UserId;
                if (!string.IsNullOrEmpty(request.UserLastName))
                    serviceRequest.UserLastName = request.UserLastName;

                var proxy = Service.Wcf.ServiceFactory.GetAppealServiceReference();
                var stubResponse = proxy.getVISTAVeteranAppointmentsByDateRange(serviceRequest);

                if (stubResponse != null)
                {
                    if (stubResponse.Appointments == null || stubResponse.Appointments.Length == 0)
                    {
                        if (stubResponse.ExceptionOccured)
                        {
                            response.ExceptionOccured = stubResponse.ExceptionOccured;
                            response.Message = stubResponse.Message;
                        }
                        else
                        {
                            response.ExceptionOccured = false;
                            response.Message = "Zero Records Returned for the requested data range.";
                        }
                    }
                    else
                    {
                        response = MapAppointmentsDateRangeResponse(stubResponse);
                        response.ExceptionOccured = false;
                        response.Message = "Processor Returned Valuse";
                        response.OrganizationName = "IMS";
                        if (!string.IsNullOrEmpty(request.PatientIdentifier))
                            response.PatientIdentifier = request.PatientIdentifier;
                    }
                }
                else
                {
                    response.ExceptionOccured = true;
                    response.Message = "Request returned Null response. Check the Server Status or contact your administrator.";
                }

                return response;
            }
            catch (NetworkOperationCancelledException ex)
            {
                if (ex.InnerException.ToString().Contains("There was no endpoint listening"))
                {
                    throw new InvalidOperationException(ex.InnerException.ToString());
                }
                else
                {
                    throw new NetworkOperationCancelledException(ex.Message);
                }
            }
            catch (Exception ex)
            {
                if (ex.InnerException != null)
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "AppointmentsProcessor, Execute", "Exception:" + ex.Message + ex.InnerException.ToString());
                }
                else
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "AppointmentsProcessor, Execute", "Exception:" + ex.Message + "No Inner Exception Text");
                }

                if (ex.Message.Contains("No Endpoint Listening"))
                {
                    throw new NetworkOperationCancelledException(ex.InnerException.ToString());
                }
                else
                {
                    throw new InvalidOperationException(ex.Message.ToString());
                }
            }

        }

        public LoadVISTAAppointmentsDateRangeResponse MapAppointmentsDateRangeResponse(Service.DataStubServiceReference.VISTAVeteranAppointmentDateRangeResponse response)
        {
            LoadVISTAAppointmentsDateRangeResponse returnMappedResponse = new LoadVISTAAppointmentsDateRangeResponse();

            List<VeteranAppointment> apptList = new List<VeteranAppointment>();

            //returnMappedResponse.AppointmentCollection[ = response.ExceptionOccured;

            foreach (var appt in response.Appointments)
            {
                var appointment = new VeteranAppointment();

                if (appt.AppointmentDate != null)
                    appointment.AppointmentDate = appt.AppointmentDate;
                if (appt.AppointmentIdentifier != null)
                    appointment.AppointmentIdentifier = appt.AppointmentIdentifier;
                if (appt.SOPCode != null)
                    appointment.SOPCode = appt.SOPCode;
                if (appt.PatientIdentifier != null)
                    appointment.PatientIdentifier = appt.PatientIdentifier;
                if (appt.FacilityIdentifier != null)
                    appointment.FacilityIdentifier = appt.FacilityIdentifier;
                if (appt.Message != null)
                    appointment.Message = appt.Message;
                if (appt.ExceptionOccured)
                    appointment.ExceptionOccured = appt.ExceptionOccured;

                // Set the system key identifier
                appointment.OriginatingSystemIdentifier = "VISTA";

                apptList.Add(appointment);
            }

            if(!string.IsNullOrEmpty(response.DateRangeSearch))
                returnMappedResponse.DateRangeSearch = response.DateRangeSearch;
            returnMappedResponse.Appointments = apptList.ToArray();

            return returnMappedResponse;
        }
    }
}

