﻿using System;
using VIMT.Integrations.Appointments.Messages;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;


namespace VIMT.Integrations.Appointments.WebService.Processors
{
    public class VISTAAppointmentDetailProcessor
    {
        public LoadVISTAAppointmentDetailResponse Execute(LoadVISTAAppointmentDetailRequest request)
        {
            try
            {
                LoadVISTAAppointmentDetailResponse response = new LoadVISTAAppointmentDetailResponse();

                Service.DataStubServiceReference.VISTAVeteranAppointmentDetailRequest serviceRequest = new Service.DataStubServiceReference.VISTAVeteranAppointmentDetailRequest();
                serviceRequest.MessageId = Guid.NewGuid();
                serviceRequest.AppointmentIdentifier = request.AppointmentIdentifier;
                serviceRequest.PatientIdentifier = request.PatientIdentifier;
                serviceRequest.FacilityIdentifier = request.FacilityIdentifier;
                serviceRequest.OrganizationName = request.OrganizationName;
                serviceRequest.UserFirstName = request.UserFirstName;
                serviceRequest.UserId = request.UserId;
                serviceRequest.UserLastName = request.UserLastName;

                var proxy = Service.Wcf.ServiceFactory.GetAppealServiceReference();
                var stubResponse = proxy.getVISTAVeteranAppointmentByAppointmentIdentifier(serviceRequest);

                if (stubResponse != null)
                {
                    if (stubResponse.AppointmentDate == null)
                    {
                        response.ExceptionOccured = true;
                        response.Message = "A record was returned but it did not contain a date value for the requested Appointment Identifier.";
                    }
                    else
                    {
                        response = MapAppointmentDetailResponse(stubResponse);
                        response.ExceptionOccured = false;
                        response.Message = "Processor Returned Valuse";
                        response.PatientIdentifier = request.PatientIdentifier;
                    }
                }
                else
                {
                    response.ExceptionOccured = true;
                    response.Message = "Request returned Null response. Check the Server Status or contact your administrator.";
                }

                return response;
            }
            catch (NetworkOperationCancelledException ex)
            {
                if (ex.InnerException.ToString().Contains("There was no endpoint listening"))
                {
                    throw new InvalidOperationException(ex.InnerException.ToString());
                }
                else
                {
                    throw new NetworkOperationCancelledException(ex.Message);
                }
            }
            catch (Exception ex)
            {
                if (ex.InnerException != null)
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "AppointmentsProcessor, Execute", "Exception:" + ex.Message + ex.InnerException.ToString());
                }
                else
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "AppointmentsProcessor, Execute", "Exception:" + ex.Message + "No Inner Exception Text");
                }

                if (ex.Message.Contains("No Endpoint Listening"))
                {
                    throw new NetworkOperationCancelledException(ex.InnerException.ToString());
                }
                else
                {
                    throw new InvalidOperationException(ex.Message.ToString());
                }
            }

        }

        public LoadVISTAAppointmentDetailResponse MapAppointmentDetailResponse(Service.DataStubServiceReference.VISTAVeteranAppointmentDetailResponse response)
        {
            LoadVISTAAppointmentDetailResponse returnMappedResponse = new LoadVISTAAppointmentDetailResponse();

            if (response.AppointmentDate != null)
                returnMappedResponse.AppointmentDate = response.AppointmentDate;
            if (response.AppointmentIdentifier != null)
                returnMappedResponse.AppointmentIdentifier = response.AppointmentIdentifier;
            if (response.SOPCode != null)
                returnMappedResponse.SOPCode = response.SOPCode;
            if (response.PatientIdentifier != null)
                returnMappedResponse.PatientIdentifier = response.PatientIdentifier;
            if (response.FacilityIdentifier != null)
                returnMappedResponse.FacilityIdentifier = response.FacilityIdentifier;
            if (response.AppointmentStatus != null)
                returnMappedResponse.AppointmentStatus = response.AppointmentStatus;
            if (response.IsInNetwork)
                returnMappedResponse.IsInNetwork = response.IsInNetwork;
            if (response.Message != null)
                returnMappedResponse.Message = response.Message;
            if (response.ExceptionOccured)
                returnMappedResponse.ExceptionOccured = response.ExceptionOccured;

            // Set the system key identifier
            returnMappedResponse.OriginatingSystemIdentifier = "VISTA";

            return returnMappedResponse;
        }
    }
}

