﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIMT.Integrations.Appointments.Messages;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;


namespace VIMT.Integrations.Appointments.WebService.Processors
{
    public class AppointmentsProcessor
    {
        public LoadVISTAAppointmentsResponse Execute(LoadVISTAAppointmentsRequest request)
        {
            try
            {
                LoadVISTAAppointmentsResponse response = new LoadVISTAAppointmentsResponse();

                Service.DataStubServiceReference.VISTAVeteranAppointmentRangeRequest serviceRequest = new Service.DataStubServiceReference.VISTAVeteranAppointmentRangeRequest();
                serviceRequest.AppointmentStartDate = DateTime.Parse(request.AppointmentStartDate);
                serviceRequest.AppointmentEndDate = DateTime.Parse(request.AppointmentEndDate);
                serviceRequest.PatientIdentifier = request.PatientIdentifier;
                serviceRequest.OrganizationName = request.OrganizationName;
                serviceRequest.UserFirstName = request.UserFirstName;
                serviceRequest.UserId = request.UserId;
                serviceRequest.UserLastName = request.UserLastName;

                var proxy = Service.Wcf.ServiceFactory.GetAppealServiceReference();
                var stubResponse = proxy.getVISTAVeteranScheduledAppointments(serviceRequest);

                if (stubResponse != null)
                {
                    if (stubResponse.Appointments == null || stubResponse.Appointments.Length == 0)
                    {
                        response.ExceptionOccured = false;
                        response.Message = "Zero Records Returned for the requested data range.";
                    }
                    else
                    {
                        response = MapAppointmentsResponse(stubResponse);
                        response.ExceptionOccured = false;
                        response.Message = "Processor Returned Valuse";
                        response.OrganizationName = "IMS";
                        response.PatientIdentifier = request.PatientIdentifier;
                    }
                }
                else
                {
                    response.ExceptionOccured = true;
                    response.Message = "Request returned Null response. Check the Server Status or contact your administrator.";
                }


                return response;
            }
            catch (NetworkOperationCancelledException ex)
            {
                if (ex.InnerException.ToString().Contains("There was no endpoint listening"))
                {
                    throw new InvalidOperationException(ex.InnerException.ToString());
                }
                else
                {
                    throw new NetworkOperationCancelledException(ex.Message);
                }
            }
            catch (Exception ex)
            {
                if (ex.InnerException != null)
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "AppointmentsProcessor, Execute", "Exception:" + ex.Message + ex.InnerException.ToString());
                }
                else
                {
                    LogHelper.LogError(request.OrganizationName, null, request.UserId, "AppointmentsProcessor, Execute", "Exception:" + ex.Message + "No Inner Exception Text");
                }

                if (ex.Message.Contains("No Endpoint Listening"))
                {
                    throw new NetworkOperationCancelledException(ex.InnerException.ToString());
                }
                else
                {
                    throw new InvalidOperationException(ex.Message.ToString());
                }
            }

        }

        public LoadVISTAAppointmentsResponse MapAppointmentsResponse(Service.DataStubServiceReference.VISTAVeteranAppointmentRangeResponse response)
        {
            LoadVISTAAppointmentsResponse returnMappedResponse = new LoadVISTAAppointmentsResponse();

            List<VeteranAppointment> apptList = new List<VeteranAppointment>();

            //returnMappedResponse.AppointmentCollection[ = response.ExceptionOccured;

            foreach (var appt in response.Appointments)
            {
                var appointment = new VeteranAppointment();

                if (appt.AppointmentDate != null)
                    appointment.AppointmentDate = appt.AppointmentDate;
                if (appt.AppointmentIdentifier != null)
                    appointment.AppointmentIdentifier = appt.AppointmentIdentifier;
                if (appt.SOPCode != null)
                    appointment.SOPCode = appt.SOPCode;
                if (appt.PatientIdentifier != null)
                    appointment.PatientIdentifier = appt.PatientIdentifier;
                if (appt.FacilityIdentifier != null)
                    appointment.FacilityIdentifier = appt.FacilityIdentifier;
                if (appt.Message != null)
                    appointment.Message = appt.Message;
                if (appt.ExceptionOccured)
                    appointment.ExceptionOccured = appt.ExceptionOccured;

                apptList.Add(appointment);
            }


            returnMappedResponse.Appointments = apptList.ToArray();

            return returnMappedResponse;
        }
    }
}
