﻿using System;
using System.ComponentModel.Composition;
using VIMT.Integrations.Appointments.Messages;
using VIMT.Integrations.Appointments.WebService.Processors;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.Appointments.WebService.Handlers
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.LoadVISTAAppointmentsDateRangeRequest)]
    public class VISTAAppointmentsDateRangeHandler : RequestResponseHandler
    {
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                var AppointmentsMessage = message as LoadVISTAAppointmentsDateRangeRequest;
                if (AppointmentsMessage != null)
                {
                    LogMessageReceipt(AppointmentsMessage);
                    return new VISTAAppointmentsDateRangeProcessor().Execute(AppointmentsMessage);
                }
                return null;
            }
            catch (Exception ex)
            {
                //Log exception and rethrow
                Logger.Instance.Error("Exception from AppointmentsHandler", ex);
                throw;
            }
        }
    }
}
