﻿using System;
using System.ComponentModel.Composition;
using VIMT.Integrations.Appointments.Messages;
using VIMT.Integrations.Appointments.WebService.Processors;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.Appointments.WebService.Handlers
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.LoadVISTAAppointmentDetailRequest)]
    public class VISTAppointmentDetailHandler : RequestResponseHandler
    {
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                if (message != null)
                {
                    LogMessageReceipt(message);

                    var processor = new VISTAAppointmentDetailProcessor();

                    return processor.Execute((LoadVISTAAppointmentDetailRequest)message);
                }
                return null;
            }
            catch (Exception ex)
            {
                //Log exception and rethrow
                Logger.Instance.Error("Exception from AppointmentsHandler", ex);
                throw;
            }
        }
    }
}
