﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIMT.Integrations.Appointments.Messages;
using VIMT.Integrations.Appointments.WebService.Processors;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.Appointments.WebService.Handlers
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.LoadVISTAAppointmentsRequest)]
    public class AppointmentsHandler : RequestResponseHandler
    {
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                var AppointmentsMessage = message as LoadVISTAAppointmentsRequest;
                if (AppointmentsMessage != null)
                {
                    LogMessageReceipt(AppointmentsMessage);
                    return new AppointmentsProcessor().Execute(AppointmentsMessage);
                }
                return null;
            }
            catch (Exception ex)
            {
                //Log exception and rethrow
                Logger.Instance.Error("Exception from AppointmentsHandler", ex);
                throw;
            }
        }
    }
}
