﻿using Microsoft.Xrm.Sdk;
using System;
using VIMT.Integrations.Appointments.Service.Configuration;
using VIMT.Integrations.Appointments.Service.DataStubServiceReference;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.Appointments.Service.Wcf
{
    public class ServiceFactory
    {
        public static IDataStubService GetAppealServiceReference(IOrganizationService organizationService, Guid userId)
        {
            var channel = new ServiceCustomClientChannel<IDataStubService>("BasicHttpBinding_IDataStubService", ConfigurationLocation.GetConfigFilePath("EC"));

            channel.Endpoint.AddSecurityHeader(organizationService, userId);

            SoapLog.Current.Active = AppointmentsConfiguration.Current.EnableLogging;

            return channel.CreateChannel();
        }

        public static IDataStubService GetAppealServiceReference(HeaderInfo headerInfo)
        {
            var channel = new ServiceCustomClientChannel<IDataStubService>("BasicHttpBinding_IDataStubService", ConfigurationLocation.GetConfigFilePath("EC"));

            channel.Endpoint.AddSecurityHeader(headerInfo);

            SoapLog.Current.Active = AppointmentsConfiguration.Current.EnableLogging;

            return channel.CreateChannel();
        }

        public static IDataStubService GetAppealServiceReference()
        {
            var channel = new ServiceCustomClientChannel<IDataStubService>("BasicHttpBinding_IDataStubService", ConfigurationLocation.GetConfigFilePath("EC"));

            return channel.CreateChannel();
        }
    }
}
