﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.Appointments.Service.Configuration
{
    [Serializable]
    public class AppointmentsConfiguration : ObjectConfigHandler
    {
        public AppointmentsConfiguration()
        { }

        public static AppointmentsConfiguration Current
        {
            get
            {
                var configurationFileReader = new CustomConfigurationFileReader();

                var section = configurationFileReader.GetCustomConfig<AppointmentsConfiguration>(ConfigurationLocation.ConfigDefiningAssemblyPath, ConfigurationLocation.GetConfigFilePath("EC"), "AppointmentsConfiguration");

                if (section == null)
                {
                    throw new Exception("Cannot find Appointments configuration");
                }
                return section;
            }
        }

        public string UserName { get; set; }
        public string Password { get; set; }
        public string ClientMachine { get; set; }
        public string StnId { get; set; }
        public string ApplicationId { get; set; }
        public bool RequiresClientCertificate { get; set; }
        public string ClientCertificateName { get; set; }
        public bool EnableLogging { get; set; }
    }
}
