﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VIMT.Integrations.Appointments.Messages
{
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.LoadVISTAAppointmentsDateRangeRequest)]
    [DataContract]
    public class LoadVISTAAppointmentsDateRangeRequest : MessageBase
    {
        [DataMember]
        public string AppointmentStartDate { get; set; }

        [DataMember]
        public string AppointmentEndDate { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public string UserFirstName { get; set; }

        [DataMember]
        public Guid UserId { get; set; }

        [DataMember]
        public string UserLastName { get; set; }
    }

    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.LoadVISTAAppointmentsDateRangeResponse)]
    [DataContract]
    public class LoadVISTAAppointmentsDateRangeResponse : MessageBase
    {
        [DataMember]
        public string DateRangeSearch { get; set; }

        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }
        [DataMember]
        public VeteranAppointment[] Appointments { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

    }

    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.LoadVISTAAppointmentDetailRequest)]
    [DataContract]
    public class LoadVISTAAppointmentDetailRequest : MessageBase
    {
        [DataMember]
        public string AppointmentIdentifier { get; set; }

        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public string UserFirstName { get; set; }

        [DataMember]
        public Guid UserId { get; set; }

        [DataMember]
        public string UserLastName { get; set; }
    }

    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.LoadVISTAAppointmentDetailResponse)]
    [DataContract]
    public class LoadVISTAAppointmentDetailResponse : MessageBase
    {
        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public string OriginatingSystemIdentifier { get; set; }

        [DataMember]
        public string AppointmentIdentifier { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public DateTime AppointmentDate { get; set; }

        [DataMember]
        public string AppointmentStatus { get; set; }

        [DataMember]
        public string SOPCode { get; set; }

        [DataMember]
        public Boolean IsInNetwork { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }
    }

    [DataContract]
    public class VeteranAppointment
    {
        [DataMember]
        public string OriginatingSystemIdentifier { get; set; }

        [DataMember]
        public string FacilityIdentifier { get; set; }

        [DataMember]
        public DateTime AppointmentDate { get; set; }

        [DataMember]
        public string AppointmentStatus { get; set; }

        [DataMember]
        public string SOPCode { get; set; }

        [DataMember]
        public string AppointmentIdentifier { get; set; }

        [DataMember]
        public string PatientIdentifier { get; set; }

        [DataMember]
        public string Message { get; set; }

        [DataMember]
        public Boolean ExceptionOccured { get; set; }
    }
}
