﻿using System;
using Microsoft.QualityTools.Testing.Fakes;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace BMS.VistaIntegration.Via.Tests
{
    public abstract class UnitTestBase
    {
        private IDisposable shimsContext;

        protected UnitTestBase()
        {
        }

        public TestContext TestContext
        {
            get;
            set;
        }

        [TestInitialize]
        public void TestInitialize()
        {
            var testMethod = this.GetType().GetMethod(this.TestContext.TestName);
            if (testMethod.GetCustomAttributes(typeof(RequiresShimsContextAttribute), false).Length > 0)
            {
                this.shimsContext = ShimsContext.Create();
            }
        }

        [TestCleanup]
        public void TestCleanup()
        {
            if (this.shimsContext != null)
            {
                this.shimsContext.Dispose();
                this.shimsContext = null;
            }
        }
    }

    [AttributeUsage(AttributeTargets.Method, AllowMultiple = false, Inherited = false)]
    public sealed class RequiresShimsContextAttribute : Attribute
    {
    }
}
