﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Schedulers.DateTimeValidators.CalendarValidators
{


    public class MonthlyRecurs : IDateTimeValidator
    {
        public struct RunOnDay
        {
            public RunOnDay(int dayIndex) { DayIndex = dayIndex; Day = null; }
            public RunOnDay(int dayIndex, DayOfWeek day) { DayIndex = dayIndex; Day = day; }
            public readonly int DayIndex;
            public readonly DayOfWeek? Day;
        }

        public RunOnDay OnDay { get; private set; }
        public int RecursEvery { get; private set; }

        private DateTime currentFirstDayOfMonth;
        private DateTime nextFirstDayOfMounth;


        public MonthlyRecurs(int recursEvery, RunOnDay onDay)
        {
            RecursEvery = recursEvery;
            OnDay = onDay;
        }

        public void Init(DateTime dateTimeStarted)
        {
            currentFirstDayOfMonth = dateTimeStarted.Date.AddDays(-dateTimeStarted.Day + 1).AddMonths(-1);
            nextFirstDayOfMounth = currentFirstDayOfMonth.AddMonths(RecursEvery);
        }

        private bool CheckRecursEvery(DateTime now)
        {

            DateTime firstDayOfMounth = now.Date.AddDays(-now.Day + 1);
            if (firstDayOfMounth == currentFirstDayOfMonth)
                return true;
            if (firstDayOfMounth == nextFirstDayOfMounth)
            {
                currentFirstDayOfMonth = nextFirstDayOfMounth;
                nextFirstDayOfMounth = nextFirstDayOfMounth.AddMonths(RecursEvery);
                return true;
            }
            return false;
        }

        private bool CheckOnDay(DateTime now)
        {
            bool result;
            if (!OnDay.Day.HasValue)
                result = now.Day == OnDay.DayIndex;
            else
            {
                result = OnDay.Day.Value == now.DayOfWeek &
                         (now.Day + 6) / 7 == OnDay.DayIndex;
            }
            return result;
        }

        public bool IsValid(DateTime now)
        {
            bool checkRecursEvery = CheckRecursEvery(now);
            bool result = checkRecursEvery & CheckOnDay(now);
            return result;
        }
    }
}
