﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using Mdws2ORM.Core;

namespace Mdws2ORM
{
    [Serializable]
    public class MdwsException : Exception
    {

        public MdwsException() { }

        public MdwsException(string message) : base(message) { }

        public MdwsException(string message, Exception innerException)
            : base(message, innerException) { }

        public MdwsException(Exception innerException)
            : base("See InnerException", innerException) { }

        protected MdwsException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }

        private List<string> rpcStack = new List<string>();

        public IEnumerable<string> RpcStack { get { return rpcStack; } }

        private static string GetTypeName<T>()
        {
            Type type = typeof(T);
            if (type.IsGenericType)
            {
                StringBuilder sb = new StringBuilder(type.Name);
                sb.Append('[');
                type.GetGenericArguments().ForEach(s =>
                    {
                        sb.Append(s.Name);
                        sb.Append(',');
                    });
                sb[sb.Length - 1] = ']';
                return sb.ToString();

            }
            else return type.Name;
        }

        internal void AddGetRpc<T>(QueryParam queryParam, GetParam getParam, string iens)
        {
            string rpc = string.Format("Get {0} {1}{2}{3}", GetTypeName<T>(), queryParam, getParam, GetIenParam(iens));
            rpcStack.Add(rpc);
        }

        internal void AddListRpc<T>(QueryParam queryParam, ListParam listParam, string iens)
        {
            string rpc = string.Format("List {0} {1}{2}{3}", GetTypeName<T>(), queryParam, listParam, GetIenParam(iens));
            rpcStack.Add(rpc);
        }

        private static string GetIenParam(string iens)
        {
            if (iens == "") return "";
            else return "IENS=" + iens;
        }

        public override string ToString()
        {
            if (!rpcStack.Any()) return base.ToString();
            StringBuilder sb = new StringBuilder("\nRpcStack:\n");
            rpcStack.ForEach(s => sb.AppendLine(s));
            return base.ToString() + sb.ToString();
        }
    }
}
